[workflow-core](../../index.md) / [com.squareup.workflow](../index.md) / [StatefulWorkflow](index.md) / [render](./render.md)

# render

`abstract fun render(props: PropsT, state: StateT, context: `[`RenderContext`](../-render-context/index.md)`<StateT, OutputT>): RenderingT`

Called at least once† any time one of the following things happens:

* This workflow's [props](render.md#com.squareup.workflow.StatefulWorkflow$render(com.squareup.workflow.StatefulWorkflow.PropsT, com.squareup.workflow.StatefulWorkflow.StateT, com.squareup.workflow.RenderContext((com.squareup.workflow.StatefulWorkflow.StateT, com.squareup.workflow.StatefulWorkflow.OutputT)))/props) changes (via the parent passing a different one in).
* This workflow's [state](render.md#com.squareup.workflow.StatefulWorkflow$render(com.squareup.workflow.StatefulWorkflow.PropsT, com.squareup.workflow.StatefulWorkflow.StateT, com.squareup.workflow.RenderContext((com.squareup.workflow.StatefulWorkflow.StateT, com.squareup.workflow.StatefulWorkflow.OutputT)))/state) changes.
* A descendant (immediate or transitive child) workflow:
  * Changes its internal state.
  * Emits an output.

**Never call this method directly.** To nest the rendering of a child workflow in your own,
pass the child and any required props to [RenderContext.renderChild](../-render-context/render-child.md).

This method *should not* have any side effects, and in particular should not do anything that
blocks the current thread. It may be called multiple times for the same state. It must do all its
work by calling methods on [context](render.md#com.squareup.workflow.StatefulWorkflow$render(com.squareup.workflow.StatefulWorkflow.PropsT, com.squareup.workflow.StatefulWorkflow.StateT, com.squareup.workflow.RenderContext((com.squareup.workflow.StatefulWorkflow.StateT, com.squareup.workflow.StatefulWorkflow.OutputT)))/context).

*† This method is guaranteed to be called *at least* once for every state, but may be calledmultiple times. Allowing this method to be invoked multiple times makes the internals simpler.*

