[workflow-core](../../index.md) / [com.squareup.workflow](../index.md) / [WorkflowAction](./index.md)

# WorkflowAction

`interface WorkflowAction<StateT, out OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`

An atomic operation that updates the state of a [Workflow](../-workflow/index.md), and also optionally emits an output.

### Types

| Name | Summary |
|---|---|
| [Updater](-updater/index.md) | The context for calls to [WorkflowAction.apply](#). Allows the action to set the [nextState](-updater/next-state.md), and to emit the [setOutput](-updater/set-output.md).`class Updater<S, in O : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |

### Functions

| Name | Summary |
|---|---|
| [apply](apply.md) | `open fun Updater<StateT, OutputT>.apply(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [noAction](no-action.md) | Returns a [WorkflowAction](./index.md) that does nothing: no output will be emitted, and `render` will be called again with the same `state` as last time.`fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> noAction(): `[`WorkflowAction`](./index.md)`<StateT, OutputT>` |

### Extension Functions

| Name | Summary |
|---|---|
| [applyTo](../apply-to.md) | `fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> `[`WorkflowAction`](./index.md)`<StateT, OutputT>.applyTo(state: StateT): `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<StateT, OutputT?>` |
