[workflow-core](../../index.md) / [com.squareup.workflow](../index.md) / [Workflow](./index.md)

# Workflow

`interface Workflow<in PropsT, out OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, out RenderingT>`

A composable, optionally-stateful object that can [handle events](#),
[delegate to children](../-render-context/render-child.md), [subscribe](#) to
arbitrary asynchronous events from the outside world.

The basic purpose of a `Workflow` is to take some input (in the form of [PropsT](index.md#PropsT)) and
return a [rendering](index.md#RenderingT). To that end, a workflow may keep track of internal
[state](../-stateful-workflow/index.md), recursively ask other workflows to render themselves, subscribe to
data streams from the outside world, and handle events both from its
[renderings](#) and from workflows it's delegated to (its "children"). A
`Workflow` may also emit [output events](index.md#OutputT) up to its parent `Workflow`.

Workflows form a tree, where each workflow can have zero or more child workflows. Child workflows
are started as necessary whenever another workflow asks for them, and are cleaned up
automatically when they're no longer needed. [Props](index.md#PropsT) propagates down the tree,
[outputs](index.md#OutputT) and [renderings](index.md#RenderingT) propagate up the tree.

## Implementing `Workflow`

The [Workflow](./index.md) interface is useful as a facade for your API. You can publish an interface that
extends `Workflow`, and keep the implementation (e.g. is your workflow state*ful* or
state*less* a private implementation detail.

### [Stateful Workflows](../-stateful-workflow/index.md)

If your workflow needs to keep track of internal state, implement the [StatefulWorkflow](../-stateful-workflow/index.md)
interface. That interface has an additional type parameter, `StateT`, and allows you to specify
[how to create the initial state](../-stateful-workflow/initial-state.md) and how to
[snapshot](../-stateful-workflow/snapshot-state.md)/restore your state.

### [Stateless Workflows](../-stateless-workflow/index.md)

If your workflow simply needs to delegate to other workflows, maybe transforming propss, outputs,
or renderings, extend [StatelessWorkflow](../-stateless-workflow/index.md), or just pass a lambda to the [stateless](../stateless.md) function
below.

## Interacting with Events and Other Workflows

All workflows are passed a [RenderContext](../-render-context/index.md) in their render methods. This context allows the
workflow to interact with the outside world by doing things like listening for events,
subscribing to streams of data, rendering child workflows, and performing cleanup when the
workflow is about to be torn down by its parent. See the documentation on [RenderContext](../-render-context/index.md) for
more information about what it can do.

### Parameters

`PropsT` - Typically a data class that is used to pass configuration information or bits of
state that the workflow can always get from its parent and needn't duplicate in its own state.
May be [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) if the workflow does not need any props data.

`OutputT` - Typically a sealed class that represents "events" that this workflow can send
to its parent.
May be [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html) if the workflow doesn't need to emit anything.

`RenderingT` - The value returned to this workflow's parent during [composition](../render-child.md).
Typically represents a "view" of this workflow's props, current state, and children's renderings.
A workflow that represents a UI component may use a view model as its rendering type.

**See Also**

[StatefulWorkflow](../-stateful-workflow/index.md)

[StatelessWorkflow](../-stateless-workflow/index.md)

### Functions

| Name | Summary |
|---|---|
| [asStatefulWorkflow](as-stateful-workflow.md) | Provides a [StatefulWorkflow](../-stateful-workflow/index.md) view of this workflow. Necessary because [StatefulWorkflow](../-stateful-workflow/index.md) is the common API required for [RenderContext.renderChild](../-render-context/render-child.md) to do its work.`abstract fun asStatefulWorkflow(): `[`StatefulWorkflow`](../-stateful-workflow/index.md)`<PropsT, *, OutputT, RenderingT>` |

### Extension Functions

| Name | Summary |
|---|---|
| [mapRendering](../map-rendering.md) | Uses the given [function](../map-rendering.md#com.squareup.workflow$mapRendering(com.squareup.workflow.Workflow((com.squareup.workflow.mapRendering.PropsT, com.squareup.workflow.mapRendering.OutputT, com.squareup.workflow.mapRendering.FromRenderingT)), kotlin.Function1((com.squareup.workflow.mapRendering.FromRenderingT, com.squareup.workflow.mapRendering.ToRenderingT)))/transform) to transform a [Workflow](./index.md) that renders [FromRenderingT](../map-rendering.md#FromRenderingT) to one renders [ToRenderingT](../map-rendering.md#ToRenderingT),`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, FromRenderingT, ToRenderingT> `[`Workflow`](./index.md)`<PropsT, OutputT, FromRenderingT>.mapRendering(transform: (FromRenderingT) -> ToRenderingT): `[`Workflow`](./index.md)`<PropsT, OutputT, ToRenderingT>` |

### Companion Object Extension Functions

| Name | Summary |
|---|---|
| [rendering](../rendering.md) | Returns a workflow that does nothing but echo the given [rendering](../rendering.md#com.squareup.workflow$rendering(com.squareup.workflow.Workflow.Companion, com.squareup.workflow.rendering.RenderingT)/rendering). Handy for testing.`fun <OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow.Companion.rendering(rendering: RenderingT): `[`Workflow`](./index.md)`<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, OutputT, RenderingT>` |
| [stateful](../stateful.md) | Returns a stateful [Workflow](./index.md) implemented via the given functions.`fun <PropsT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow.Companion.stateful(initialState: (PropsT, `[`Snapshot`](../-snapshot/index.md)`?) -> StateT, render: `[`RenderContext`](../-render-context/index.md)`<StateT, OutputT>.(props: PropsT, state: StateT) -> RenderingT, snapshot: (StateT) -> `[`Snapshot`](../-snapshot/index.md)`, onPropsChanged: (old: PropsT, new: PropsT, state: StateT) -> StateT = { _, _, state -> state }): `[`StatefulWorkflow`](../-stateful-workflow/index.md)`<PropsT, StateT, OutputT, RenderingT>`<br>`fun <PropsT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow.Companion.stateful(initialState: (PropsT) -> StateT, render: `[`RenderContext`](../-render-context/index.md)`<StateT, OutputT>.(props: PropsT, state: StateT) -> RenderingT, onPropsChanged: (old: PropsT, new: PropsT, state: StateT) -> StateT = { _, _, state -> state }): `[`StatefulWorkflow`](../-stateful-workflow/index.md)`<PropsT, StateT, OutputT, RenderingT>`<br>Returns a stateful [Workflow](./index.md), with no props, implemented via the given functions.`fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow.Companion.stateful(initialState: (`[`Snapshot`](../-snapshot/index.md)`?) -> StateT, render: `[`RenderContext`](../-render-context/index.md)`<StateT, OutputT>.(state: StateT) -> RenderingT, snapshot: (StateT) -> `[`Snapshot`](../-snapshot/index.md)`): `[`StatefulWorkflow`](../-stateful-workflow/index.md)`<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, StateT, OutputT, RenderingT>`<br>Returns a stateful [Workflow](./index.md), with no props, implemented via the given function.`fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow.Companion.stateful(initialState: StateT, render: `[`RenderContext`](../-render-context/index.md)`<StateT, OutputT>.(state: StateT) -> RenderingT): `[`StatefulWorkflow`](../-stateful-workflow/index.md)`<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, StateT, OutputT, RenderingT>` |
| [stateless](../stateless.md) | Returns a stateless [Workflow](./index.md) via the given [render](../stateless.md#com.squareup.workflow$stateless(com.squareup.workflow.Workflow.Companion, kotlin.Function2((com.squareup.workflow.RenderContext((kotlin.Nothing, com.squareup.workflow.stateless.OutputT)), com.squareup.workflow.stateless.PropsT, com.squareup.workflow.stateless.RenderingT)))/render) function.`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow.Companion.stateless(render: `[`RenderContext`](../-render-context/index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, OutputT>.(props: PropsT) -> RenderingT): `[`Workflow`](./index.md)`<PropsT, OutputT, RenderingT>` |

### Inheritors

| Name | Summary |
|---|---|
| [StatefulWorkflow](../-stateful-workflow/index.md) | A composable, stateful object that can [handle events](../-render-context/action-sink.md), [delegate to children](../-render-context/render-child.md), [subscribe](../-render-context/running-worker.md) to arbitrary asynchronous events from the outside world, and be [saved](../-stateful-workflow/snapshot-state.md) to a serialized form to be restored later.`abstract class StatefulWorkflow<in PropsT, StateT, out OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, out RenderingT> : `[`Workflow`](./index.md)`<PropsT, OutputT, RenderingT>` |
| [StatelessWorkflow](../-stateless-workflow/index.md) | Minimal implementation of [Workflow](./index.md) that maintains no state of its own.`abstract class StatelessWorkflow<in PropsT, out OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, out RenderingT> : `[`Workflow`](./index.md)`<PropsT, OutputT, RenderingT>` |
