[workflow-core](../index.md) / [com.squareup.workflow](index.md) / [action](./action.md)

# action

`fun <PropsT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> `[`StatefulWorkflow`](-stateful-workflow/index.md)`<PropsT, StateT, OutputT, RenderingT>.action(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", update: Updater<StateT, OutputT>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowAction`](-workflow-action/index.md)`<StateT, OutputT>`

Convenience to create a [WorkflowAction](-workflow-action/index.md) with parameter types matching those
of the receiving [StatefulWorkflow](-stateful-workflow/index.md). The action will invoke the given [lambda](action.md#com.squareup.workflow$action(com.squareup.workflow.StatefulWorkflow((com.squareup.workflow.action.PropsT, com.squareup.workflow.action.StateT, com.squareup.workflow.action.OutputT, com.squareup.workflow.action.RenderingT)), kotlin.String, kotlin.Function1((com.squareup.workflow.WorkflowAction.Updater((com.squareup.workflow.action.StateT, com.squareup.workflow.action.OutputT)), kotlin.Unit)))/update)
when it is [applied](#).

### Parameters

`name` - A string describing the update for debugging, included in [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html).

`update` - Function that defines the workflow update.`fun <PropsT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> `[`StatefulWorkflow`](-stateful-workflow/index.md)`<PropsT, StateT, OutputT, RenderingT>.action(name: () -> `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, update: Updater<StateT, OutputT>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowAction`](-workflow-action/index.md)`<StateT, OutputT>`

Convenience to create a [WorkflowAction](-workflow-action/index.md) with parameter types matching those
of the receiving [StatefulWorkflow](-stateful-workflow/index.md). The action will invoke the given [lambda](action.md#com.squareup.workflow$action(com.squareup.workflow.StatefulWorkflow((com.squareup.workflow.action.PropsT, com.squareup.workflow.action.StateT, com.squareup.workflow.action.OutputT, com.squareup.workflow.action.RenderingT)), kotlin.Function0((kotlin.String)), kotlin.Function1((com.squareup.workflow.WorkflowAction.Updater((com.squareup.workflow.action.StateT, com.squareup.workflow.action.OutputT)), kotlin.Unit)))/update)
when it is [applied](#).

### Parameters

`name` - Function that returns a string describing the update for debugging, included
in [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html).

`update` - Function that defines the workflow update.`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> `[`StatelessWorkflow`](-stateless-workflow/index.md)`<PropsT, OutputT, RenderingT>.action(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", update: Updater<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, OutputT>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowAction`](-workflow-action/index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, OutputT>`

Convenience to create a [WorkflowAction](-workflow-action/index.md) with parameter types matching those
of the receiving [StatefulWorkflow](-stateful-workflow/index.md). The action will invoke the given [lambda](action.md#com.squareup.workflow$action(com.squareup.workflow.StatelessWorkflow((com.squareup.workflow.action.PropsT, com.squareup.workflow.action.OutputT, com.squareup.workflow.action.RenderingT)), kotlin.String, kotlin.Function1((com.squareup.workflow.WorkflowAction.Updater((kotlin.Nothing, com.squareup.workflow.action.OutputT)), kotlin.Unit)))/update)
when it is [applied](#).

### Parameters

`name` - A string describing the update for debugging, included in [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/to-string.html).

`update` - Function that defines the workflow update.`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> `[`StatelessWorkflow`](-stateless-workflow/index.md)`<PropsT, OutputT, RenderingT>.action(name: () -> `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, update: Updater<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, OutputT>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowAction`](-workflow-action/index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, OutputT>`

Convenience to create a [WorkflowAction](-workflow-action/index.md) with parameter types matching those
of the receiving [StatefulWorkflow](-stateful-workflow/index.md). The action will invoke the given [lambda](action.md#com.squareup.workflow$action(com.squareup.workflow.StatelessWorkflow((com.squareup.workflow.action.PropsT, com.squareup.workflow.action.OutputT, com.squareup.workflow.action.RenderingT)), kotlin.Function0((kotlin.String)), kotlin.Function1((com.squareup.workflow.WorkflowAction.Updater((kotlin.Nothing, com.squareup.workflow.action.OutputT)), kotlin.Unit)))/update)
when it is [applied](#).

### Parameters

`name` - Function that returns a string describing the update for debugging, included in
[toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/to-string.html).

`update` - Function that defines the workflow update.`inline fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> action(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", crossinline apply: Updater<StateT, OutputT>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowAction`](-workflow-action/index.md)`<StateT, OutputT>`

Creates a [WorkflowAction](-workflow-action/index.md) from the [apply](action.md#com.squareup.workflow$action(kotlin.String, kotlin.Function1((com.squareup.workflow.WorkflowAction.Updater((com.squareup.workflow.action.StateT, com.squareup.workflow.action.OutputT)), kotlin.Unit)))/apply) lambda.
The returned object will include the string returned from [name](action.md#com.squareup.workflow$action(kotlin.String, kotlin.Function1((com.squareup.workflow.WorkflowAction.Updater((com.squareup.workflow.action.StateT, com.squareup.workflow.action.OutputT)), kotlin.Unit)))/name) in its [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html).

If defining actions within a [StatefulWorkflow](-stateful-workflow/index.md), use the [StatefulWorkflow.workflowAction](#)
extension instead, to do this without being forced to repeat its parameter types.

### Parameters

`name` - A string describing the update for debugging.

`apply` - Function that defines the workflow update.

**See Also**

[StatelessWorkflow.action](./action.md)

[StatefulWorkflow.action](./action.md)

`inline fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> action(crossinline name: () -> `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, crossinline apply: Updater<StateT, OutputT>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowAction`](-workflow-action/index.md)`<StateT, OutputT>`

Creates a [WorkflowAction](-workflow-action/index.md) from the [apply](action.md#com.squareup.workflow$action(kotlin.Function0((kotlin.String)), kotlin.Function1((com.squareup.workflow.WorkflowAction.Updater((com.squareup.workflow.action.StateT, com.squareup.workflow.action.OutputT)), kotlin.Unit)))/apply) lambda.
The returned object will include the string returned from [name](action.md#com.squareup.workflow$action(kotlin.Function0((kotlin.String)), kotlin.Function1((com.squareup.workflow.WorkflowAction.Updater((com.squareup.workflow.action.StateT, com.squareup.workflow.action.OutputT)), kotlin.Unit)))/name) in its [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html).

If defining actions within a [StatefulWorkflow](-stateful-workflow/index.md), use the [StatefulWorkflow.workflowAction](#)
extension instead, to do this without being forced to repeat its parameter types.

### Parameters

`name` - Function that returns a string describing the update for debugging.

`apply` - Function that defines the workflow update.

**See Also**

[StatelessWorkflow.action](./action.md)

[StatefulWorkflow.action](./action.md)

