[workflow-core](../index.md) / [com.squareup.workflow](./index.md)

## Package com.squareup.workflow

### Types

| Name | Summary |
|---|---|
| [LifecycleWorker](-lifecycle-worker/index.md) | [Worker](-worker/index.md) that performs some action when the worker is started and/or stopped.`abstract class LifecycleWorker : `[`Worker`](-worker/index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>` |
| [RenderContext](-render-context/index.md) | Facilities for a [Workflow](-workflow/index.md) to interact with other [Workflow](-workflow/index.md)s and the outside world from inside a `render` function.`interface RenderContext<StateT, in OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
| [Sink](-sink/index.md) | An object that receives values (commonly events or [WorkflowAction](-workflow-action/index.md)). [RenderContext.actionSink](-render-context/action-sink.md) implements this interface.`interface Sink<in T>` |
| [Snapshot](-snapshot/index.md) | A lazy wrapper of [ByteString](#). Allows [Workflow](-workflow/index.md)s to capture their state frequently, without worrying about performing unnecessary serialization work.`class Snapshot` |
| [StatefulWorkflow](-stateful-workflow/index.md) | A composable, stateful object that can [handle events](-render-context/action-sink.md), [delegate to children](-render-context/render-child.md), [subscribe](-render-context/running-worker.md) to arbitrary asynchronous events from the outside world, and be [saved](-stateful-workflow/snapshot-state.md) to a serialized form to be restored later.`abstract class StatefulWorkflow<in PropsT, StateT, out OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, out RenderingT> : `[`Workflow`](-workflow/index.md)`<PropsT, OutputT, RenderingT>` |
| [StatelessWorkflow](-stateless-workflow/index.md) | Minimal implementation of [Workflow](-workflow/index.md) that maintains no state of its own.`abstract class StatelessWorkflow<in PropsT, out OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, out RenderingT> : `[`Workflow`](-workflow/index.md)`<PropsT, OutputT, RenderingT>` |
| [Worker](-worker/index.md) | Represents a unit of asynchronous work that can have zero, one, or multiple outputs.`interface Worker<out OutputT>` |
| [Workflow](-workflow/index.md) | A composable, optionally-stateful object that can [handle events](#), [delegate to children](-render-context/render-child.md), [subscribe](#) to arbitrary asynchronous events from the outside world.`interface Workflow<in PropsT, out OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, out RenderingT>` |
| [WorkflowAction](-workflow-action/index.md) | An atomic operation that updates the state of a [Workflow](-workflow/index.md), and also optionally emits an output.`interface WorkflowAction<StateT, out OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |

### Annotations

| Name | Summary |
|---|---|
| [VeryExperimentalWorkflow](-very-experimental-workflow/index.md) | Marks Workflow APIs that are extremely likely to change in future versions, rely themselves on other unstable, experimental APIs, and SHOULD NOT be used in production code. Proceed with caution, and be ready to have the rug pulled out from under you.`annotation class VeryExperimentalWorkflow` |

### Extensions for External Classes

| Name | Summary |
|---|---|
| [kotlinx.coroutines.channels.BroadcastChannel](kotlinx.coroutines.channels.-broadcast-channel/index.md) |  |
| [kotlinx.coroutines.channels.ReceiveChannel](kotlinx.coroutines.channels.-receive-channel/index.md) |  |
| [kotlinx.coroutines.Deferred](kotlinx.coroutines.-deferred/index.md) |  |
| [kotlinx.coroutines.flow.Flow](kotlinx.coroutines.flow.-flow/index.md) |  |
| [okio.BufferedSink](okio.-buffered-sink/index.md) |  |
| [okio.BufferedSource](okio.-buffered-source/index.md) |  |
| [okio.ByteString](okio.-byte-string/index.md) |  |

### Functions

| Name | Summary |
|---|---|
| [action](action.md) | Convenience to create a [WorkflowAction](-workflow-action/index.md) with parameter types matching those of the receiving [StatefulWorkflow](-stateful-workflow/index.md). The action will invoke the given [lambda](action.md#com.squareup.workflow$action(com.squareup.workflow.StatefulWorkflow((com.squareup.workflow.action.PropsT, com.squareup.workflow.action.StateT, com.squareup.workflow.action.OutputT, com.squareup.workflow.action.RenderingT)), kotlin.String, kotlin.Function1((com.squareup.workflow.WorkflowAction.Updater((com.squareup.workflow.action.StateT, com.squareup.workflow.action.OutputT)), kotlin.Unit)))/update) when it is [applied](#).`fun <PropsT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> `[`StatefulWorkflow`](-stateful-workflow/index.md)`<PropsT, StateT, OutputT, RenderingT>.action(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", update: Updater<StateT, OutputT>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowAction`](-workflow-action/index.md)`<StateT, OutputT>`<br>`fun <PropsT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> `[`StatefulWorkflow`](-stateful-workflow/index.md)`<PropsT, StateT, OutputT, RenderingT>.action(name: () -> `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, update: Updater<StateT, OutputT>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowAction`](-workflow-action/index.md)`<StateT, OutputT>`<br>`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> `[`StatelessWorkflow`](-stateless-workflow/index.md)`<PropsT, OutputT, RenderingT>.action(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", update: Updater<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, OutputT>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowAction`](-workflow-action/index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, OutputT>`<br>`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> `[`StatelessWorkflow`](-stateless-workflow/index.md)`<PropsT, OutputT, RenderingT>.action(name: () -> `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, update: Updater<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, OutputT>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowAction`](-workflow-action/index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, OutputT>`<br>Creates a [WorkflowAction](-workflow-action/index.md) from the [apply](action.md#com.squareup.workflow$action(kotlin.String, kotlin.Function1((com.squareup.workflow.WorkflowAction.Updater((com.squareup.workflow.action.StateT, com.squareup.workflow.action.OutputT)), kotlin.Unit)))/apply) lambda. The returned object will include the string returned from [name](action.md#com.squareup.workflow$action(kotlin.String, kotlin.Function1((com.squareup.workflow.WorkflowAction.Updater((com.squareup.workflow.action.StateT, com.squareup.workflow.action.OutputT)), kotlin.Unit)))/name) in its [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html).`fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> action(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", apply: Updater<StateT, OutputT>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowAction`](-workflow-action/index.md)`<StateT, OutputT>`<br>`fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> action(name: () -> `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, apply: Updater<StateT, OutputT>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowAction`](-workflow-action/index.md)`<StateT, OutputT>` |
| [applyTo](apply-to.md) | `fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> `[`WorkflowAction`](-workflow-action/index.md)`<StateT, OutputT>.applyTo(state: StateT): `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<StateT, OutputT?>` |
| [contraMap](contra-map.md) | Generates a new sink of type [T2](contra-map.md#T2).`fun <T1, T2> `[`Sink`](-sink/index.md)`<T1>.contraMap(transform: (T2) -> T1): `[`Sink`](-sink/index.md)`<T2>` |
| [invoke](invoke.md) | [EventHandler](#)s of type `Unit` are effectively no-arg functions, so this override lets you invoke them without passing the `Unit` argument.`operator fun EventHandler<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`>.invoke(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [makeEventSink](make-event-sink.md) | Alternative to [RenderContext.actionSink](-render-context/action-sink.md) that allows externally defined event types to be mapped to anonymous [WorkflowAction](-workflow-action/index.md)s.`fun <EventT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> `[`RenderContext`](-render-context/index.md)`<StateT, OutputT>.makeEventSink(update: Updater<StateT, OutputT>.(EventT) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Sink`](-sink/index.md)`<EventT>` |
| [mapRendering](map-rendering.md) | Uses the given [function](map-rendering.md#com.squareup.workflow$mapRendering(com.squareup.workflow.Workflow((com.squareup.workflow.mapRendering.PropsT, com.squareup.workflow.mapRendering.OutputT, com.squareup.workflow.mapRendering.FromRenderingT)), kotlin.Function1((com.squareup.workflow.mapRendering.FromRenderingT, com.squareup.workflow.mapRendering.ToRenderingT)))/transform) to transform a [Workflow](-workflow/index.md) that renders [FromRenderingT](map-rendering.md#FromRenderingT) to one renders [ToRenderingT](map-rendering.md#ToRenderingT),`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, FromRenderingT, ToRenderingT> `[`Workflow`](-workflow/index.md)`<PropsT, OutputT, FromRenderingT>.mapRendering(transform: (FromRenderingT) -> ToRenderingT): `[`Workflow`](-workflow/index.md)`<PropsT, OutputT, ToRenderingT>` |
| [renderChild](render-child.md) | Convenience alias of [RenderContext.renderChild](-render-context/render-child.md) for workflows that don't take props.`fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, ChildOutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, ChildRenderingT> `[`RenderContext`](-render-context/index.md)`<StateT, OutputT>.renderChild(child: `[`Workflow`](-workflow/index.md)`<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, ChildOutputT, ChildRenderingT>, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", handler: (ChildOutputT) -> `[`WorkflowAction`](-workflow-action/index.md)`<StateT, OutputT>): ChildRenderingT`<br>Convenience alias of [RenderContext.renderChild](-render-context/render-child.md) for workflows that don't take props or emit output.`fun <PropsT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, ChildRenderingT> `[`RenderContext`](-render-context/index.md)`<StateT, OutputT>.renderChild(child: `[`Workflow`](-workflow/index.md)`<PropsT, `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, ChildRenderingT>, props: PropsT, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = ""): ChildRenderingT`<br>`fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, ChildRenderingT> `[`RenderContext`](-render-context/index.md)`<StateT, OutputT>.renderChild(child: `[`Workflow`](-workflow/index.md)`<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, ChildRenderingT>, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = ""): ChildRenderingT` |
| [runningWorker](running-worker.md) | Ensures a [Worker](-worker/index.md) that never emits anything is running. Since [worker](running-worker.md#com.squareup.workflow$runningWorker(com.squareup.workflow.RenderContext((com.squareup.workflow.runningWorker.StateT, com.squareup.workflow.runningWorker.OutputT)), com.squareup.workflow.Worker((kotlin.Nothing)), kotlin.String)/worker) can't emit anything, it can't trigger any [WorkflowAction](-workflow-action/index.md)s.`fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> `[`RenderContext`](-render-context/index.md)`<StateT, OutputT>.runningWorker(worker: `[`Worker`](-worker/index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = ""): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [transform](transform.md) | Returns a [Worker](-worker/index.md) that transforms this [Worker](-worker/index.md)'s [Flow](#) by calling [transform](transform.md#com.squareup.workflow$transform(com.squareup.workflow.Worker((com.squareup.workflow.transform.T)), kotlin.Function1((kotlinx.coroutines.flow.Flow((com.squareup.workflow.transform.T)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.transform.R)))))/transform).`fun <T, R> `[`Worker`](-worker/index.md)`<T>.transform(transform: (Flow<T>) -> Flow<R>): `[`Worker`](-worker/index.md)`<R>` |

### Companion Object Functions

| Name | Summary |
|---|---|
| [rendering](rendering.md) | Returns a workflow that does nothing but echo the given [rendering](rendering.md#com.squareup.workflow$rendering(com.squareup.workflow.Workflow.Companion, com.squareup.workflow.rendering.RenderingT)/rendering). Handy for testing.`fun <OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow.Companion.rendering(rendering: RenderingT): `[`Workflow`](-workflow/index.md)`<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, OutputT, RenderingT>` |
| [stateful](stateful.md) | Returns a stateful [Workflow](-workflow/index.md) implemented via the given functions.`fun <PropsT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow.Companion.stateful(initialState: (PropsT, `[`Snapshot`](-snapshot/index.md)`?) -> StateT, render: `[`RenderContext`](-render-context/index.md)`<StateT, OutputT>.(props: PropsT, state: StateT) -> RenderingT, snapshot: (StateT) -> `[`Snapshot`](-snapshot/index.md)`, onPropsChanged: (old: PropsT, new: PropsT, state: StateT) -> StateT = { _, _, state -> state }): `[`StatefulWorkflow`](-stateful-workflow/index.md)`<PropsT, StateT, OutputT, RenderingT>`<br>`fun <PropsT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow.Companion.stateful(initialState: (PropsT) -> StateT, render: `[`RenderContext`](-render-context/index.md)`<StateT, OutputT>.(props: PropsT, state: StateT) -> RenderingT, onPropsChanged: (old: PropsT, new: PropsT, state: StateT) -> StateT = { _, _, state -> state }): `[`StatefulWorkflow`](-stateful-workflow/index.md)`<PropsT, StateT, OutputT, RenderingT>`<br>Returns a stateful [Workflow](-workflow/index.md), with no props, implemented via the given functions.`fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow.Companion.stateful(initialState: (`[`Snapshot`](-snapshot/index.md)`?) -> StateT, render: `[`RenderContext`](-render-context/index.md)`<StateT, OutputT>.(state: StateT) -> RenderingT, snapshot: (StateT) -> `[`Snapshot`](-snapshot/index.md)`): `[`StatefulWorkflow`](-stateful-workflow/index.md)`<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, StateT, OutputT, RenderingT>`<br>Returns a stateful [Workflow](-workflow/index.md), with no props, implemented via the given function.`fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow.Companion.stateful(initialState: StateT, render: `[`RenderContext`](-render-context/index.md)`<StateT, OutputT>.(state: StateT) -> RenderingT): `[`StatefulWorkflow`](-stateful-workflow/index.md)`<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, StateT, OutputT, RenderingT>` |
| [stateless](stateless.md) | Returns a stateless [Workflow](-workflow/index.md) via the given [render](stateless.md#com.squareup.workflow$stateless(com.squareup.workflow.Workflow.Companion, kotlin.Function2((com.squareup.workflow.RenderContext((kotlin.Nothing, com.squareup.workflow.stateless.OutputT)), com.squareup.workflow.stateless.PropsT, com.squareup.workflow.stateless.RenderingT)))/render) function.`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow.Companion.stateless(render: `[`RenderContext`](-render-context/index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, OutputT>.(props: PropsT) -> RenderingT): `[`Workflow`](-workflow/index.md)`<PropsT, OutputT, RenderingT>` |
