[workflow-core](../index.md) / [com.squareup.workflow](index.md) / [stateful](./stateful.md)

# stateful

`inline fun <PropsT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow.Companion.stateful(crossinline initialState: (PropsT, `[`Snapshot`](-snapshot/index.md)`?) -> StateT, crossinline render: `[`RenderContext`](-render-context/index.md)`<StateT, OutputT>.(props: PropsT, state: StateT) -> RenderingT, crossinline snapshot: (StateT) -> `[`Snapshot`](-snapshot/index.md)`, crossinline onPropsChanged: (old: PropsT, new: PropsT, state: StateT) -> StateT = { _, _, state -> state }): `[`StatefulWorkflow`](-stateful-workflow/index.md)`<PropsT, StateT, OutputT, RenderingT>`

Returns a stateful [Workflow](-workflow/index.md) implemented via the given functions.

`inline fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow.Companion.stateful(crossinline initialState: (`[`Snapshot`](-snapshot/index.md)`?) -> StateT, crossinline render: `[`RenderContext`](-render-context/index.md)`<StateT, OutputT>.(state: StateT) -> RenderingT, crossinline snapshot: (StateT) -> `[`Snapshot`](-snapshot/index.md)`): `[`StatefulWorkflow`](-stateful-workflow/index.md)`<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, StateT, OutputT, RenderingT>`

Returns a stateful [Workflow](-workflow/index.md), with no props, implemented via the given functions.

`inline fun <PropsT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow.Companion.stateful(crossinline initialState: (PropsT) -> StateT, crossinline render: `[`RenderContext`](-render-context/index.md)`<StateT, OutputT>.(props: PropsT, state: StateT) -> RenderingT, crossinline onPropsChanged: (old: PropsT, new: PropsT, state: StateT) -> StateT = { _, _, state -> state }): `[`StatefulWorkflow`](-stateful-workflow/index.md)`<PropsT, StateT, OutputT, RenderingT>`

Returns a stateful [Workflow](-workflow/index.md) implemented via the given functions.

This overload does not support snapshotting, but there are other overloads that do.

`inline fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow.Companion.stateful(initialState: StateT, crossinline render: `[`RenderContext`](-render-context/index.md)`<StateT, OutputT>.(state: StateT) -> RenderingT): `[`StatefulWorkflow`](-stateful-workflow/index.md)`<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, StateT, OutputT, RenderingT>`

Returns a stateful [Workflow](-workflow/index.md), with no props, implemented via the given function.

This overload does not support snapshots, but there are others that do.

