[workflow-core](../index.md) / [com.squareup.workflow](index.md) / [transform](./transform.md)

# transform

`fun <T, R> `[`Worker`](-worker/index.md)`<T>.transform(transform: (Flow<T>) -> Flow<R>): `[`Worker`](-worker/index.md)`<R>`

Returns a [Worker](-worker/index.md) that transforms this [Worker](-worker/index.md)'s [Flow](#) by calling [transform](transform.md#com.squareup.workflow$transform(com.squareup.workflow.Worker((com.squareup.workflow.transform.T)), kotlin.Function1((kotlinx.coroutines.flow.Flow((com.squareup.workflow.transform.T)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.transform.R)))))/transform).

The returned worker is considered equivalent with any other worker returned by this function
with the same receiver.

## Examples

### Workers from the same source are equivalent

```
val secondsWorker = millisWorker.transform {
  it.map { millis -> millis / 1000 }.distinctUntilChanged()
}

val otherSecondsWorker = millisWorker.transform {
  it.map { millis -> millis.toSeconds() }
}

assert(secondsWorker.doesSameWorkAs(otherSecondsWorker))
```

### Workers from different sources are not equivalent

```
val secondsWorker = millisWorker.transform {
  it.map { millis -> millis / 1000 }.distinctUntilChanged()
}

val otherSecondsWorker = secondsWorker.transform { it }

assert(!secondsWorker.doesSameWorkAs(otherSecondsWorker))
```

