[workflow-runtime](../../index.md) / [com.squareup.workflow.diagnostic](../index.md) / [DebugSnapshotRecordingListener](./index.md)

# DebugSnapshotRecordingListener

`@VeryExperimentalWorkflow class DebugSnapshotRecordingListener : `[`WorkflowDiagnosticListener`](../-workflow-diagnostic-listener/index.md)

A [WorkflowDiagnosticListener](../-workflow-diagnostic-listener/index.md) that records [WorkflowHierarchyDebugSnapshot](../-workflow-hierarchy-debug-snapshot/index.md)s and
[WorkflowUpdateDebugInfo](../-workflow-update-debug-info/index.md)s and sends them to [debugger](#) after each render pass.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | A [WorkflowDiagnosticListener](../-workflow-diagnostic-listener/index.md) that records [WorkflowHierarchyDebugSnapshot](../-workflow-hierarchy-debug-snapshot/index.md)s and [WorkflowUpdateDebugInfo](../-workflow-update-debug-info/index.md)s and sends them to [debugger](#) after each render pass.`DebugSnapshotRecordingListener(debugger: (`[`WorkflowHierarchyDebugSnapshot`](../-workflow-hierarchy-debug-snapshot/index.md)`, `[`WorkflowUpdateDebugInfo`](../-workflow-update-debug-info/index.md)`?) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`)` |

### Functions

| Name | Summary |
|---|---|
| [onAfterRenderPass](on-after-render-pass.md) | Called just after the workflow tree finishes rendering.`fun onAfterRenderPass(rendering: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onAfterWorkflowRendered](on-after-workflow-rendered.md) | Called just after an individual workflow's render method was called.`fun onAfterWorkflowRendered(workflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, rendering: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onBeforeWorkflowRendered](on-before-workflow-rendered.md) | Called just before an individual workflow's render method is going to be called.`fun onBeforeWorkflowRendered(workflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, props: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, state: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onRuntimeStopped](on-runtime-stopped.md) | Called after the runtime has been cancelled or failed, after all workflow-related coroutines have completed.`fun onRuntimeStopped(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onSinkReceived](on-sink-received.md) | Called when a [Sink](#) has received an event.`fun onSinkReceived(workflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, action: WorkflowAction<*, *>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onWorkerOutput](on-worker-output.md) | Called when a worker emits an output.`fun onWorkerOutput(workerId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, parentWorkflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, output: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onWorkerStarted](on-worker-started.md) | Called when a workflow starts running a new worker.`fun onWorkerStarted(workerId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, parentWorkflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, description: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onWorkerStopped](on-worker-stopped.md) | Called when a worker finishes running. The workflow may still technically be "running" the worker, but it will never emit any more outputs.`fun onWorkerStopped(workerId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, parentWorkflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onWorkflowAction](on-workflow-action.md) | Called when a workflow has executed a [WorkflowAction](#) in response to a worker output or sink event.`fun onWorkflowAction(workflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, action: WorkflowAction<*, *>, oldState: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, newState: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, output: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onWorkflowStarted](on-workflow-started.md) | Called when a particular workflow node is started at a particular point in the workflow tree.`fun onWorkflowStarted(workflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, parentId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`?, workflowType: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, initialProps: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, initialState: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, restoredFromSnapshot: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onWorkflowStopped](on-workflow-stopped.md) | Called when a particular workflow node is stopped at a particular point in the workflow tree.`fun onWorkflowStopped(workflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Extension Functions

| Name | Summary |
|---|---|
| [andThen](../and-then.md) | Returns a [WorkflowDiagnosticListener](../-workflow-diagnostic-listener/index.md) that will delegate all method calls first to this instance, and then to [next](../and-then.md#com.squareup.workflow.diagnostic$andThen(com.squareup.workflow.diagnostic.WorkflowDiagnosticListener, com.squareup.workflow.diagnostic.WorkflowDiagnosticListener)/next).`fun `[`WorkflowDiagnosticListener`](../-workflow-diagnostic-listener/index.md)`.andThen(next: `[`WorkflowDiagnosticListener`](../-workflow-diagnostic-listener/index.md)`): `[`WorkflowDiagnosticListener`](../-workflow-diagnostic-listener/index.md) |
