[workflow-runtime](../../index.md) / [com.squareup.workflow.diagnostic](../index.md) / [WorkflowDiagnosticListener](./index.md)

# WorkflowDiagnosticListener

`interface WorkflowDiagnosticListener`

Receives diagnostic events from the workflow runtime when significant things happen, e.g. the
runtime starts or stops, workflows and workers are started or stopped, and information about
render passes and workflow actions.

To register a listener with the runtime, set
[WorkflowSession.diagnosticListener](../../com.squareup.workflow/-workflow-session/diagnostic-listener.md)
in the `beforeStart` function passed to
[launchWorkflowIn](../../com.squareup.workflow/launch-workflow-in.md).

Multiple listeners can be composed using the [andThen](../and-then.md) function.

No guarantees are made about what threads methods are invoked on. Implementations should take
care to be thread-safe.

## Sequence of Events

Events received by this interface occur in a well-defined order.

1. [onRuntimeStarted](on-runtime-started.md)
2. [onBeforeRenderPass](on-before-render-pass.md)
   1. [onBeforeWorkflowRendered](on-before-workflow-rendered.md)
       * Also called for each child workflow, recursively.
       * Child start are emitted before the render method returns.
          1. [onWorkflowStarted](on-workflow-started.md)
          2. [onWorkerStarted](on-worker-started.md)
   2. [onAfterWorkflowRendered](on-after-workflow-rendered.md)
   * Child stop events are emitted after the render method returns.
      * [onWorkflowStopped](on-workflow-stopped.md)
      * [onWorkerStopped](on-worker-stopped.md)
3. [onAfterRenderPass](on-after-render-pass.md)
4. [onBeforeSnapshotPass](on-before-snapshot-pass.md)
5. [onAfterSnapshotPass](on-after-snapshot-pass.md)
6. Either:
   * [onSinkReceived](on-sink-received.md)
   * [onWorkerOutput](on-worker-output.md)
7. [onWorkflowAction](on-workflow-action.md)
8. Back to [onBeforeRenderPass](on-before-render-pass.md).
9. [onRuntimeStopped](on-runtime-stopped.md)

## Detekt Configuration

If you're using Detekt, you may need to suppress some warnings when implementing this interface.

* Add `@Suppress("TooManyFunctions")` to your class.
* Add `@Suppress("LongParameterList")` to [onWorkflowStarted](on-workflow-started.md) if you override it.

### Functions

| Name | Summary |
|---|---|
| [onAfterRenderPass](on-after-render-pass.md) | Called just after the workflow tree finishes rendering.`open fun onAfterRenderPass(rendering: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onAfterSnapshotPass](on-after-snapshot-pass.md) | Called just after all the workflows' [snapshotState](#) methods are called.`open fun onAfterSnapshotPass(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onAfterWorkflowRendered](on-after-workflow-rendered.md) | Called just after an individual workflow's render method was called.`open fun onAfterWorkflowRendered(workflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, rendering: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onBeforeRenderPass](on-before-render-pass.md) | Called just before the workflow tree is going to be rendered.`open fun onBeforeRenderPass(props: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onBeforeSnapshotPass](on-before-snapshot-pass.md) | Called just before all the workflows' [snapshotState](#) methods are called.`open fun onBeforeSnapshotPass(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onBeforeWorkflowRendered](on-before-workflow-rendered.md) | Called just before an individual workflow's render method is going to be called.`open fun onBeforeWorkflowRendered(workflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, props: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, state: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onPropsChanged](on-props-changed.md) | Called after [onPropsChanged](#) returns.`open fun onPropsChanged(workflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`?, oldProps: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, newProps: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, oldState: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, newState: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onRuntimeStarted](on-runtime-started.md) | Called when the runtime has started executing.`open fun onRuntimeStarted(workflowScope: CoroutineScope, rootWorkflowType: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onRuntimeStopped](on-runtime-stopped.md) | Called after the runtime has been cancelled or failed, after all workflow-related coroutines have completed.`open fun onRuntimeStopped(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onSinkReceived](on-sink-received.md) | Called when a [Sink](#) has received an event.`open fun onSinkReceived(workflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, action: WorkflowAction<*, *>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onWorkerOutput](on-worker-output.md) | Called when a worker emits an output.`open fun onWorkerOutput(workerId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, parentWorkflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, output: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onWorkerStarted](on-worker-started.md) | Called when a workflow starts running a new worker.`open fun onWorkerStarted(workerId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, parentWorkflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, description: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onWorkerStopped](on-worker-stopped.md) | Called when a worker finishes running. The workflow may still technically be "running" the worker, but it will never emit any more outputs.`open fun onWorkerStopped(workerId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, parentWorkflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onWorkflowAction](on-workflow-action.md) | Called when a workflow has executed a [WorkflowAction](#) in response to a worker output or sink event.`open fun onWorkflowAction(workflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, action: WorkflowAction<*, *>, oldState: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, newState: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, output: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onWorkflowStarted](on-workflow-started.md) | Called when a particular workflow node is started at a particular point in the workflow tree.`open fun onWorkflowStarted(workflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, parentId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`?, workflowType: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, initialProps: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, initialState: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, restoredFromSnapshot: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onWorkflowStopped](on-workflow-stopped.md) | Called when a particular workflow node is stopped at a particular point in the workflow tree.`open fun onWorkflowStopped(workflowId: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Extension Functions

| Name | Summary |
|---|---|
| [andThen](../and-then.md) | Returns a [WorkflowDiagnosticListener](./index.md) that will delegate all method calls first to this instance, and then to [next](../and-then.md#com.squareup.workflow.diagnostic$andThen(com.squareup.workflow.diagnostic.WorkflowDiagnosticListener, com.squareup.workflow.diagnostic.WorkflowDiagnosticListener)/next).`fun `[`WorkflowDiagnosticListener`](./index.md)`.andThen(next: `[`WorkflowDiagnosticListener`](./index.md)`): `[`WorkflowDiagnosticListener`](./index.md) |

### Inheritors

| Name | Summary |
|---|---|
| [DebugSnapshotRecordingListener](../-debug-snapshot-recording-listener/index.md) | A [WorkflowDiagnosticListener](./index.md) that records [WorkflowHierarchyDebugSnapshot](../-workflow-hierarchy-debug-snapshot/index.md)s and [WorkflowUpdateDebugInfo](../-workflow-update-debug-info/index.md)s and sends them to [debugger](#) after each render pass.`class DebugSnapshotRecordingListener : `[`WorkflowDiagnosticListener`](./index.md) |
| [SimpleLoggingDiagnosticListener](../-simple-logging-diagnostic-listener/index.md) | A [WorkflowDiagnosticListener](./index.md) that just prints all events using [println](../-simple-logging-diagnostic-listener/println.md).`open class SimpleLoggingDiagnosticListener : `[`WorkflowDiagnosticListener`](./index.md) |
