[workflow-runtime](../../index.md) / [com.squareup.workflow.diagnostic](../index.md) / [WorkflowUpdateDebugInfo](./index.md)

# WorkflowUpdateDebugInfo

`data class WorkflowUpdateDebugInfo`

A description of a workflow update triggered by a [Source](-source/index.md) (worker, event, etc).

This is a simple linked list that represents a traversal down the workflow tree that starts at
the root and indicates, for each workflow, if its child output something that it handled
(see [Kind](-kind/index.md)), or if it was just a parent of a workflow that didn't output anything.

When a workflow handles an update, the type of update is indicated by [Source](-source/index.md).

### Types

| Name | Summary |
|---|---|
| [Kind](-kind/index.md) | A sealed class that indicates whether a workflow actually executed a `WorkflowAction`, or was just the ancestor of a workflow that did.`sealed class Kind` |
| [Source](-source/index.md) | A sealed class that indicates what triggered the update.`sealed class Source` |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | A description of a workflow update triggered by a [Source](-source/index.md) (worker, event, etc).`WorkflowUpdateDebugInfo(workflowType: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, kind: Kind)` |

### Properties

| Name | Summary |
|---|---|
| [kind](kind.md) | `val kind: Kind` |
| [workflowType](workflow-type.md) | `val workflowType: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Functions

| Name | Summary |
|---|---|
| [toDescriptionString](to-description-string.md) | Generates a multi-line, recursive string describing the update.`fun toDescriptionString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
