[workflow-runtime](../../../../index.md) / [com.squareup.workflow.testing](../../../index.md) / [WorkflowTestParams](../../index.md) / [StartMode](../index.md) / [StartFromWorkflowSnapshot](./index.md)

# StartFromWorkflowSnapshot

`data class StartFromWorkflowSnapshot : StartMode<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>`

Starts the workflow from its initial state (as specified by
[initial state](#)), with a non-null
snapshot.  Only applies to [StatefulWorkflow](#)s.

This differs from [StartFromCompleteSnapshot](../-start-from-complete-snapshot/index.md) because it represents only the snapshot for
the root workflow, without any of the snapshots of its children or other bookkeeping data
added by the workflow runtime.

### Parameters

`snapshot` - A [Snapshot](#) that can be directly parsed by a workflow's `initialState`
method. For workflow trees, this is only the snapshot of the *root* workflow, as returned by
[snapshotState](#). To test with a
complete snapshot of the entire workflow tree, use [StartFromCompleteSnapshot](../-start-from-complete-snapshot/index.md).

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | Starts the workflow from its initial state (as specified by [initial state](#)), with a non-null snapshot.  Only applies to [StatefulWorkflow](#)s.`StartFromWorkflowSnapshot(snapshot: Snapshot)` |

### Properties

| Name | Summary |
|---|---|
| [snapshot](snapshot.md) | A [Snapshot](#) that can be directly parsed by a workflow's `initialState` method. For workflow trees, this is only the snapshot of the *root* workflow, as returned by [snapshotState](#). To test with a complete snapshot of the entire workflow tree, use [StartFromCompleteSnapshot](../-start-from-complete-snapshot/index.md).`val snapshot: Snapshot` |
