[workflow-runtime](../../index.md) / [com.squareup.workflow](../index.md) / [WorkflowNodeBenchmark](./index.md)

# WorkflowNodeBenchmark

`open class WorkflowNodeBenchmark`

### Types

| Name | Summary |
|---|---|
| [TreeShape](-tree-shape/index.md) | `enum class TreeShape`<br>Used to parameterize the benchmarks. |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `WorkflowNodeBenchmark()` |

### Properties

| Name | Summary |
|---|---|
| [treeShape](tree-shape.md) | `var treeShape: `[`WorkflowNodeBenchmark.TreeShape`](-tree-shape/index.md) |

### Functions

| Name | Summary |
|---|---|
| [renderPassAlternateLeaves](render-pass-alternate-leaves.md) | `open fun renderPassAlternateLeaves(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Alternates between rendering leaves and not rendering leaves. The tree structure is always changing, as well as the props all the way down the tree, so this prevents props caching and measures setup/teardown cost for [WorkflowNode](#)s. |
| [renderPassAlternateOneLeaf](render-pass-alternate-one-leaf.md) | `open fun renderPassAlternateOneLeaf(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>This benchmark is equivalent to [renderPassAlternateLeaves](render-pass-alternate-leaves.md) for the [TreeShape.DEEP](-tree-shape/-d-e-e-p.md) case. |
| [renderPassAlternateWorkers](render-pass-alternate-workers.md) | `open fun renderPassAlternateWorkers(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Alternates between having every leaf run a worker, and having no leaves run workers. Measures setup/teardown cost for [Worker](#)s. |
| [renderPassAlwaysLeaves](render-pass-always-leaves.md) | `open fun renderPassAlwaysLeaves(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Always renders leaves. After the first render pass, the tree structure never changes, so this measures no-op render passes. |
| [setUp](set-up.md) | `open fun setUp(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
