[workflow-runtime](../index.md) / [com.squareup.workflow](index.md) / [launchWorkflowIn](./launch-workflow-in.md)

# launchWorkflowIn

`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT, RunnerT> launchWorkflowIn(scope: CoroutineScope, workflow: Workflow<PropsT, OutputT, RenderingT>, props: Flow<PropsT>, initialSnapshot: Snapshot? = null, beforeStart: CoroutineScope.(session: `[`WorkflowSession`](-workflow-session/index.md)`<OutputT, RenderingT>) -> RunnerT): RunnerT`

Launches the [workflow](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/workflow) in a new coroutine in [scope](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/scope). The workflow tree is seeded with
[initialSnapshot](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/initialSnapshot) and the first value emitted by [props](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/props).  Subsequent values emitted from
[props](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/props) will be used to re-render the workflow.

This is the primary low-level entry point into the workflow runtime. If you are writing an app,
you should probably be using a higher-level entry point that will also let you define UI bindings
for your renderings.

## Initialization

Before starting the actual workflow runtime, this function will invoke [beforeStart](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/beforeStart) and pass
it the [Flow](#)s of renderings, snapshots, and outputs, as well as a [CoroutineScope](#) that the
runtime will be hosted in. The workflow runtime will not be started until after this function
returns. This is to allow the output flow to start being collected before any outputs can
actually be emitted. Collectors that start *after* [beforeStart](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/beforeStart) returns may not receive outputs
that are emitted very quickly. The value returned by [beforeStart](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/beforeStart) will be returned from this
function after the runtime is launched, handy for instantiating platform-specific runner objects.
The [CoroutineScope](#) passed to [beforeStart](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/beforeStart) can be used to do more than just cancel the runtime
– it can also be used to start coroutines that will run until the workflow is cancelled,
typically to collect the rendering and output [Flow](#)s.

## Scoping

The workflow runtime makes use of
[structured concurrency](https://medium.com/@elizarov/structured-concurrency-722d765aa952).
The runtime is started in a specific [CoroutineScope](#), which defines the context for the entire
workflow tree – most importantly, the [Job](#) that governs the runtime's lifetime and exception
reporting path, and the [CoroutineDispatcher](#) that
decides on what threads to run workflow code.

This function creates a child [Job](#) in [scope](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/scope) and uses it as the parent for the workflow
runtime, and as the job passed to the [beforeStart](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/beforeStart) function. This means that if [beforeStart](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/beforeStart)
calls [CoroutineScope.cancel](#), it will cancel the workflow runtime, but will not cancel the
[scope](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/scope) passed into this function.

### Parameters

`scope` - The [CoroutineScope](#) in which to launch the workflow runtime. Any exceptions thrown
in any workflows will be reported to this scope, and cancelling this scope will cancel the
workflow runtime. The scope passed to [beforeStart](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/beforeStart) will be a child of this scope.

`workflow` - The root workflow to start.

`props` - Stream of input values for the root workflow. The first value emitted is passed to
the root workflow's [StatefulWorkflow.initialState](#), and subsequent emissions are passed as
input updates to the root workflow. If this flow completes before emitting anything, the runtime
will fail (report an exception up through [scope](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/scope)). If this flow completes *after* emitting at
least one value, the runtime will *not* fail or stop, it will continue running with the
last-emitted input.

`initialSnapshot` - If not null or empty, used to restore the workflow.

`beforeStart` - Called exactly once with the flows for renderings/snapshots and outputs.
It also gets a sub-scope of [scope](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/scope) with a newly created child [Job](#) which defines the lifetime
of the launched workflow tree. Cancelling that job ends the new workflow session.
Note that if [scope](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/scope) is already cancelled when this function is called, the receiver scope will
also be cancelled, and the flows will complete immediately.

**Return**
The value returned by [beforeStart](launch-workflow-in.md#com.squareup.workflow$launchWorkflowIn(kotlinx.coroutines.CoroutineScope, com.squareup.workflow.Workflow((com.squareup.workflow.launchWorkflowIn.PropsT, com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.launchWorkflowIn.PropsT)), com.squareup.workflow.Snapshot, kotlin.Function2((kotlinx.coroutines.CoroutineScope, com.squareup.workflow.WorkflowSession((com.squareup.workflow.launchWorkflowIn.OutputT, com.squareup.workflow.launchWorkflowIn.RenderingT)), com.squareup.workflow.launchWorkflowIn.RunnerT)))/beforeStart).

