[workflow-testing](../../index.md) / [com.squareup.workflow.testing](../index.md) / [MockChildWorkflow](./index.md)

# MockChildWorkflow

`class MockChildWorkflow<P, R> : Workflow<`[`P`](index.md#P)`, `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, `[`R`](index.md#R)`>`

A mock implementation of [Workflow](#) for use in tests with `testRender` and [TestRenderResult](../-test-render-result/index.md).

Note this workflow can not actually emit any output itself. Use
[TestRenderResult.handleOutput](../-test-render-result/handle-output.md) to evaluate output handlers.

### Parameters

`renderer` - Function that is invoked in each render pass to calculate the rendering.

**See Also**

[StatefulWorkflow.testRender](#)

[com.squareup.workflow.StatelessWorkflow.testRender](#)

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `MockChildWorkflow(rendering: `[`R`](index.md#R)`)`<br>Creates a [MockChildWorkflow](./index.md) that will always render the same value, [rendering](-init-.md#com.squareup.workflow.testing.MockChildWorkflow$<init>(com.squareup.workflow.testing.MockChildWorkflow.R)/rendering).`MockChildWorkflow(renderer: (`[`P`](index.md#P)`) -> `[`R`](index.md#R)`)`<br>A mock implementation of [Workflow](#) for use in tests with `testRender` and [TestRenderResult](../-test-render-result/index.md). |

### Properties

| Name | Summary |
|---|---|
| [lastSeenProps](last-seen-props.md) | `val lastSeenProps: `[`P`](index.md#P)<br>Returns the last input value used to render this instance. |

### Functions

| Name | Summary |
|---|---|
| [asStatefulWorkflow](as-stateful-workflow.md) | `fun asStatefulWorkflow(): StatefulWorkflow<`[`P`](index.md#P)`, *, `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, `[`R`](index.md#R)`>` |

### Extension Functions

| Name | Summary |
|---|---|
| [renderTester](../com.squareup.workflow.-workflow/render-tester.md) | `fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow<`[`PropsT`](../com.squareup.workflow.-workflow/render-tester.md#PropsT)`, `[`OutputT`](../com.squareup.workflow.-workflow/render-tester.md#OutputT)`, `[`RenderingT`](../com.squareup.workflow.-workflow/render-tester.md#RenderingT)`>.renderTester(props: `[`PropsT`](../com.squareup.workflow.-workflow/render-tester.md#PropsT)`): `[`RenderTester`](../-render-tester/index.md)`<`[`PropsT`](../com.squareup.workflow.-workflow/render-tester.md#PropsT)`, *, `[`OutputT`](../com.squareup.workflow.-workflow/render-tester.md#OutputT)`, `[`RenderingT`](../com.squareup.workflow.-workflow/render-tester.md#RenderingT)`>`<br>Create a [RenderTester](../-render-tester/index.md) to unit test an individual render pass of this workflow. |
| [testFromStart](../com.squareup.workflow.-workflow/test-from-start.md) | `fun <T, PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow<`[`PropsT`](../com.squareup.workflow.-workflow/test-from-start.md#PropsT)`, `[`OutputT`](../com.squareup.workflow.-workflow/test-from-start.md#OutputT)`, `[`RenderingT`](../com.squareup.workflow.-workflow/test-from-start.md#RenderingT)`>.testFromStart(props: `[`PropsT`](../com.squareup.workflow.-workflow/test-from-start.md#PropsT)`, testParams: WorkflowTestParams<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`> = WorkflowTestParams(), context: `[`CoroutineContext`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.coroutines/-coroutine-context/index.html)` = EmptyCoroutineContext, block: `[`WorkflowTester`](../-workflow-tester/index.md)`<`[`PropsT`](../com.squareup.workflow.-workflow/test-from-start.md#PropsT)`, `[`OutputT`](../com.squareup.workflow.-workflow/test-from-start.md#OutputT)`, `[`RenderingT`](../com.squareup.workflow.-workflow/test-from-start.md#RenderingT)`>.() -> `[`T`](../com.squareup.workflow.-workflow/test-from-start.md#T)`): `[`T`](../com.squareup.workflow.-workflow/test-from-start.md#T)<br>`fun <T, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> Workflow<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, `[`OutputT`](../com.squareup.workflow.-workflow/test-from-start.md#OutputT)`, `[`RenderingT`](../com.squareup.workflow.-workflow/test-from-start.md#RenderingT)`>.testFromStart(testParams: WorkflowTestParams<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`> = WorkflowTestParams(), context: `[`CoroutineContext`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.coroutines/-coroutine-context/index.html)` = EmptyCoroutineContext, block: `[`WorkflowTester`](../-workflow-tester/index.md)`<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, `[`OutputT`](../com.squareup.workflow.-workflow/test-from-start.md#OutputT)`, `[`RenderingT`](../com.squareup.workflow.-workflow/test-from-start.md#RenderingT)`>.() -> `[`T`](../com.squareup.workflow.-workflow/test-from-start.md#T)`): `[`T`](../com.squareup.workflow.-workflow/test-from-start.md#T)<br>Creates a [WorkflowTester](../-workflow-tester/index.md) to run this workflow for unit testing. |
