[workflow-testing](../../index.md) / [com.squareup.workflow.testing](../index.md) / [MockWorker](./index.md)

# MockWorker

`class MockWorker<T> : Worker<`[`T`](index.md#T)`>`

A mock implementation of [Worker](#) for use in tests with `testRender` and [TestRenderResult](../-test-render-result/index.md).

Note this [Worker](#) can not actually emit any output itself. Use
[TestRenderResult.handleOutput](../-test-render-result/handle-output.md) to evaluate output handlers.

**See Also**

[com.squareup.workflow.StatefulWorkflow.testRender](#)

[com.squareup.workflow.StatelessWorkflow.testRender](#)

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `MockWorker(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`)`<br>A mock implementation of [Worker](#) for use in tests with `testRender` and [TestRenderResult](../-test-render-result/index.md). |

### Properties

| Name | Summary |
|---|---|
| [name](name.md) | `val name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Functions

| Name | Summary |
|---|---|
| [doesSameWorkAs](does-same-work-as.md) | `fun doesSameWorkAs(otherWorker: Worker<*>): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [run](run.md) | `fun run(): Flow<`[`T`](index.md#T)`>` |

### Extension Functions

| Name | Summary |
|---|---|
| [test](../com.squareup.workflow.-worker/test.md) | `fun <T> Worker<`[`T`](../com.squareup.workflow.-worker/test.md#T)`>.test(timeoutMs: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)` = DEFAULT_TIMEOUT_MS, block: suspend `[`WorkerTester`](../-worker-tester/index.md)`<`[`T`](../com.squareup.workflow.-worker/test.md#T)`>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Test a [Worker](#) by defining assertions on its output within [block](../com.squareup.workflow.-worker/test.md#com.squareup.workflow.testing$test(com.squareup.workflow.Worker((com.squareup.workflow.testing.test.T)), kotlin.Long, kotlin.coroutines.SuspendFunction1((com.squareup.workflow.testing.WorkerTester((com.squareup.workflow.testing.test.T)), kotlin.Unit)))/block). |
