[workflow-testing](../../index.md) / [com.squareup.workflow.testing](../index.md) / [RenderTestResult](index.md) / [verifyActionResult](./verify-action-result.md)

# verifyActionResult

`abstract fun verifyActionResult(block: (newState: StateT, output: OutputT?) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)

Asserts that the render pass handled either a workflow/worker output or a rendering event,
"executes" the action with the state passed to [renderTester](../com.squareup.workflow.-workflow/render-tester.md), then invokes [block](verify-action-result.md#com.squareup.workflow.testing.RenderTestResult$verifyActionResult(kotlin.Function2((com.squareup.workflow.testing.RenderTestResult.StateT, com.squareup.workflow.testing.RenderTestResult.OutputT, kotlin.Unit)))/block) with the
resulting state and output values.

If the workflow didn't process any actions, `newState` will be the initial state and `output`
will be null.

Note that by using this method, you're also testing the implementation of your action. This can
be useful if your actions anonymous. If they are a sealed class or enum, use [verifyAction](verify-action.md)
instead and write separate unit tests for your action implementations.

