[workflow-testing](../../index.md) / [com.squareup.workflow.testing](../index.md) / [RenderTester](index.md) / [expectWorkflow](./expect-workflow.md)

# expectWorkflow

`abstract fun <ChildPropsT, ChildOutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, ChildRenderingT> expectWorkflow(workflowType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<out Workflow<ChildPropsT, ChildOutputT, ChildRenderingT>>, rendering: ChildRenderingT, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", assertProps: (props: ChildPropsT) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}, output: `[`EmittedOutput`](../-emitted-output/index.md)`<ChildOutputT>? = null): `[`RenderTester`](index.md)`<PropsT, StateT, OutputT, RenderingT>`

Specifies that this render pass is expected to render a particular child workflow.

### Parameters

`workflowType` - The [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html) of the expected workflow. May also be any of the supertypes
of the expected workflow, e.g. if the workflow type is an interface and the workflow-under-test
injects a mock.

`rendering` - The rendering to return from
[renderChild](#) when this workflow is rendered.

`key` - The key passed to [renderChild](#)
when rendering this workflow.

`assertProps` - A function that performs assertions on the props passed to
[renderChild](#).

`output` - If non-null, [EmittedOutput.output](../-emitted-output/output.md) will be "emitted" when this workflow is
rendered. The [WorkflowAction](#) used to handle this output can be verified using methods on
[RenderTestResult](../-render-test-result/index.md).