[workflow-testing](../../index.md) / [com.squareup.workflow.testing](../index.md) / [TestRenderResult](./index.md)

# TestRenderResult

`class TestRenderResult<StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT>`

Represents the result of running a single render pass on a workflow.

### Parameters

`rendering` - The actual [RenderingT](index.md#RenderingT) value returned from the workflow's `render` method.

`state` - The [StateT](index.md#StateT) passed into the `render` method.

`behavior` - The [Behavior](#) generated from the
[RenderContext](#).

### Properties

| Name | Summary |
|---|---|
| [rendering](rendering.md) | `val rendering: `[`RenderingT`](index.md#RenderingT)<br>The actual [RenderingT](index.md#RenderingT) value returned from the workflow's `render` method. |

### Functions

| Name | Summary |
|---|---|
| [assertNoWorkersRan](assert-no-workers-ran.md) | `fun assertNoWorkersRan(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Throws an [AssertionError](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-assertion-error/index.html) if any [Worker](#)s were run. |
| [assertNoWorkflowsRendered](assert-no-workflows-rendered.md) | `fun assertNoWorkflowsRendered(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Throws an [AssertionError](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-assertion-error/index.html) if any [Workflow](#)s were rendered. |
| [assertRan](assert-ran.md) | `fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> Worker<`[`T`](assert-ran.md#T)`>.assertRan(withKey: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = ""): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Throws an [AssertionError](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-assertion-error/index.html) if the render pass did not run this worker with [withKey](assert-ran.md#com.squareup.workflow.testing.TestRenderResult$assertRan(com.squareup.workflow.Worker((com.squareup.workflow.testing.TestRenderResult.assertRan.T)), kotlin.String)/withKey). |
| [assertRendered](assert-rendered.md) | `fun <CInput, COutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, CRenderingT> Workflow<`[`CInput`](assert-rendered.md#CInput)`, `[`COutputT`](assert-rendered.md#COutputT)`, `[`CRenderingT`](assert-rendered.md#CRenderingT)`>.assertRendered(withKey: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = ""): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Throws an [AssertionError](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-assertion-error/index.html) if the render pass did not render [this@assertWorkflowRendered](#) with [withKey](assert-rendered.md#com.squareup.workflow.testing.TestRenderResult$assertRendered(com.squareup.workflow.Workflow((com.squareup.workflow.testing.TestRenderResult.assertRendered.CInput, com.squareup.workflow.testing.TestRenderResult.assertRendered.COutputT, com.squareup.workflow.testing.TestRenderResult.assertRendered.CRenderingT)), kotlin.String)/withKey). |
| [getEventResult](get-event-result.md) | `fun getEventResult(): `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<`[`StateT`](index.md#StateT)`, `[`OutputT`](index.md#OutputT)`?>`<br>Call this after invoking one of the [event handlers](#) on your rendering to get the result of handling that event. |
| [handleOutput](handle-output.md) | `fun <CPropsT, COutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, CRenderingT> Workflow<`[`CPropsT`](handle-output.md#CPropsT)`, `[`COutputT`](handle-output.md#COutputT)`, `[`CRenderingT`](handle-output.md#CRenderingT)`>.handleOutput(output: `[`COutputT`](handle-output.md#COutputT)`, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = ""): `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<`[`StateT`](index.md#StateT)`, `[`OutputT`](index.md#OutputT)`?>`<br>Asserts that  this workflow was rendered with the given [key](handle-output.md#com.squareup.workflow.testing.TestRenderResult$handleOutput(com.squareup.workflow.Workflow((com.squareup.workflow.testing.TestRenderResult.handleOutput.CPropsT, com.squareup.workflow.testing.TestRenderResult.handleOutput.COutputT, com.squareup.workflow.testing.TestRenderResult.handleOutput.CRenderingT)), com.squareup.workflow.testing.TestRenderResult.handleOutput.COutputT, kotlin.String)/key) and then executes the output handler with the given [output](handle-output.md#com.squareup.workflow.testing.TestRenderResult$handleOutput(com.squareup.workflow.Workflow((com.squareup.workflow.testing.TestRenderResult.handleOutput.CPropsT, com.squareup.workflow.testing.TestRenderResult.handleOutput.COutputT, com.squareup.workflow.testing.TestRenderResult.handleOutput.CRenderingT)), com.squareup.workflow.testing.TestRenderResult.handleOutput.COutputT, kotlin.String)/output) (as an [Output](#)). Returns the new state and output returned by the output handler.`fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> Worker<`[`T`](handle-output.md#T)`>.handleOutput(output: `[`T`](handle-output.md#T)`, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = ""): `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<`[`StateT`](index.md#StateT)`, `[`OutputT`](index.md#OutputT)`?>`<br>Asserts that this worker was ran with the given [key](handle-output.md#com.squareup.workflow.testing.TestRenderResult$handleOutput(com.squareup.workflow.Worker((com.squareup.workflow.testing.TestRenderResult.handleOutput.T)), com.squareup.workflow.testing.TestRenderResult.handleOutput.T, kotlin.String)/key) and then executes the output handler with the given [output](handle-output.md#com.squareup.workflow.testing.TestRenderResult$handleOutput(com.squareup.workflow.Worker((com.squareup.workflow.testing.TestRenderResult.handleOutput.T)), com.squareup.workflow.testing.TestRenderResult.handleOutput.T, kotlin.String)/output) (as an [Output](#)). Returns the new state and output returned by the output handler. |
