[workflow-testing](../../index.md) / [com.squareup.workflow.testing](../index.md) / [WorkerTester](./index.md)

# WorkerTester

`interface WorkerTester<T>`

### Functions

| Name | Summary |
|---|---|
| [assertFinished](assert-finished.md) | Suspends until the worker emits an output or finishes.`abstract suspend fun assertFinished(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [assertNoOutput](assert-no-output.md) | Throws an [AssertionError](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-assertion-error/index.html) if an output has been emitted since the last call to [nextOutput](next-output.md).`abstract fun assertNoOutput(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [assertNotFinished](assert-not-finished.md) | Throws an [AssertionError](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-assertion-error/index.html) immediately if the worker is finished.`abstract fun assertNotFinished(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [cancelWorker](cancel-worker.md) | Cancels the worker and suspends until it's finished cancelling (joined).`abstract suspend fun cancelWorker(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [getException](get-exception.md) | Suspends until the worker throws an exception, then returns it.`abstract suspend fun getException(): `[`Throwable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html) |
| [nextOutput](next-output.md) | Suspends until the worker emits its next value, then returns it.`abstract suspend fun nextOutput(): T` |
