[workflow-testing](../../index.md) / [com.squareup.workflow.testing](../index.md) / [WorkflowTester](./index.md)

# WorkflowTester

`class WorkflowTester<PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT>`

Runs a [Workflow](#) and provides access to its
[renderings](await-next-rendering.md), [outputs](await-next-output.md), and [snapshots](await-next-snapshot.md).

For each of renderings, outputs, and snapshots, this class gives you a few ways to access
information about them:

* [awaitNextRendering](await-next-rendering.md), [awaitNextOutput](await-next-output.md), [awaitNextSnapshot](await-next-snapshot.md)
  * Block until something becomes available, and then return it.
* [hasRendering](has-rendering.md), [hasOutput](has-output.md), [hasSnapshot](has-snapshot.md)
  * Return `true` if the previous methods won't block.
* [sendProps](send-props.md)
  * Send a new [PropsT](index.md#PropsT) to the root workflow.

### Properties

| Name | Summary |
|---|---|
| [hasOutput](has-output.md) | True if the workflow has emitted a new output that is ready to be consumed.`val hasOutput: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hasRendering](has-rendering.md) | True if the workflow has emitted a new rendering that is ready to be consumed.`val hasRendering: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hasSnapshot](has-snapshot.md) | True if the workflow has emitted a new snapshot that is ready to be consumed.`val hasSnapshot: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |

### Functions

| Name | Summary |
|---|---|
| [awaitNextOutput](await-next-output.md) | Blocks until the workflow emits an output, then returns it.`fun awaitNextOutput(timeoutMs: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`? = null): OutputT` |
| [awaitNextRendering](await-next-rendering.md) | Blocks until the workflow emits a rendering, then returns it.`fun awaitNextRendering(timeoutMs: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`? = null, skipIntermediate: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = true): RenderingT` |
| [awaitNextSnapshot](await-next-snapshot.md) | Blocks until the workflow emits a snapshot, then returns it.`fun awaitNextSnapshot(timeoutMs: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`? = null, skipIntermediate: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = true): Snapshot` |
| [sendProps](send-props.md) | Sends [input](send-props.md#com.squareup.workflow.testing.WorkflowTester$sendProps(com.squareup.workflow.testing.WorkflowTester.PropsT)/input) to the workflow.`fun sendProps(input: PropsT): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Properties

| Name | Summary |
|---|---|
| [DEFAULT_TIMEOUT_MS](-d-e-f-a-u-l-t_-t-i-m-e-o-u-t_-m-s.md) | `const val DEFAULT_TIMEOUT_MS: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
