[workflow-testing](../index.md) / [com.squareup.workflow.testing](./index.md)

## Package com.squareup.workflow.testing

### Types

| Name | Summary |
|---|---|
| [EmittedOutput](-emitted-output/index.md) | Wrapper around a potentially-nullable [OutputT](-emitted-output/index.md#OutputT) value.`data class EmittedOutput<out OutputT>` |
| [RenderTester](-render-tester/index.md) | The props must be specified, the initial state may be specified, and then all child workflows and workers that are expected to run, and any outputs from them, must be specified with [expectWorkflow](-render-tester/expect-workflow.md) and [expectWorker](-render-tester/expect-worker.md) calls. Then call [render](-render-tester/render.md) and perform any assertions on the rendering. An event may also be sent to the rendering if no workflows or workers emitted an output. Lastly, the [RenderTestResult](-render-test-result/index.md) returned by `render` may be used to assert on the [WorkflowAction](#)s processed to handle events or outputs by calling [verifyAction](-render-test-result/verify-action.md) or [verifyActionResult](-render-test-result/verify-action-result.md).`interface RenderTester<PropsT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT>` |
| [RenderTestResult](-render-test-result/index.md) | Result of a [RenderTester.render](-render-tester/render.md) call that can be used to verify that a [WorkflowAction](#) was processed and perform assertions on that action.`interface RenderTestResult<StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
| [WorkerSink](-worker-sink/index.md) | Implementation of [Worker](#) for integration tests (using [testFromStart](com.squareup.workflow.-workflow/test-from-start.md) or [testFromState](com.squareup.workflow.-stateful-workflow/test-from-state.md)) that need to simply push values into the worker from the test.`class WorkerSink<T> : Worker<T>` |
| [WorkerTester](-worker-tester/index.md) | `interface WorkerTester<T>` |
| [WorkflowTester](-workflow-tester/index.md) | Runs a [Workflow](#) and provides access to its [renderings](-workflow-tester/await-next-rendering.md), [outputs](-workflow-tester/await-next-output.md), and [snapshots](-workflow-tester/await-next-snapshot.md).`class WorkflowTester<PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT>` |

### Extensions for External Classes

| Name | Summary |
|---|---|
| [com.squareup.workflow.StatefulWorkflow](com.squareup.workflow.-stateful-workflow/index.md) |  |
| [com.squareup.workflow.Worker](com.squareup.workflow.-worker/index.md) |  |
| [com.squareup.workflow.Workflow](com.squareup.workflow.-workflow/index.md) |  |

### Functions

| Name | Summary |
|---|---|
| [expectWorker](expect-worker.md) | Specifies that this render pass is expected to run a particular worker.`fun <PropsT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> `[`RenderTester`](-render-tester/index.md)`<PropsT, StateT, OutputT, RenderingT>.expectWorker(doesSameWorkAs: Worker<OutputT>, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", output: `[`EmittedOutput`](-emitted-output/index.md)`<OutputT>? = null): `[`RenderTester`](-render-tester/index.md)`<PropsT, StateT, OutputT, RenderingT>` |
| [WorkerSink](-worker-sink.md) | `fun <T> WorkerSink(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`WorkerSink`](-worker-sink/index.md)`<T>` |
