

### All Types

| Name | Summary |
|---|---|
|

##### [com.squareup.workflow.ui.AlertContainer](../com.squareup.workflow.ui/-alert-container/index.md)

Renders the [AlertScreen](#)s of an [AlertContainerScreen](#) as [AlertDialog](#)s.


|

##### [com.squareup.workflow.ui.BackPressHandler](../com.squareup.workflow.ui/-back-press-handler.md)

A function passed to [View.backPressedHandler](../com.squareup.workflow.ui/android.view.-view/back-pressed-handler.md), to be called if the back
button is pressed while that view is attached to a window.


|

##### [com.squareup.workflow.ui.backstack.BackStackConfig](../com.squareup.workflow.ui.backstack/-back-stack-config/index.md)

Informs views whether they're children of a [BackStackContainer](../com.squareup.workflow.ui.backstack/-back-stack-container/index.md),
and if so whether they're the [first frame](../com.squareup.workflow.ui.backstack/-back-stack-config/-first.md) or [not](../com.squareup.workflow.ui.backstack/-back-stack-config/-other.md).


|

##### [com.squareup.workflow.ui.backstack.BackStackContainer](../com.squareup.workflow.ui.backstack/-back-stack-container/index.md)

A container view that can display a stream of [BackStackScreen](#) instances.


|

##### [com.squareup.workflow.ui.BuilderBinding](../com.squareup.workflow.ui/-builder-binding/index.md)

A [ViewBinding](../com.squareup.workflow.ui/-view-binding/index.md) that allows a [ViewRegistry](../com.squareup.workflow.ui/-view-registry/index.md) to create [View](https://developer.android.com/reference/android/view/View.html)s that need
to be generated from code. (Use [LayoutRunner](../com.squareup.workflow.ui/-layout-runner/index.md) to work with XML layout resources.)


|

##### [com.squareup.workflow.ui.ContainerHintKey](../com.squareup.workflow.ui/-container-hint-key/index.md)

Defines a value that can be provided by a [ContainerHints](../com.squareup.workflow.ui/-container-hints/index.md) map, specifying its [type](#)
and [default](../com.squareup.workflow.ui/-container-hint-key/default.md) value.


|

##### [com.squareup.workflow.ui.ContainerHints](../com.squareup.workflow.ui/-container-hints/index.md)

Immutable, append-only map of values that a parent view can pass down to
its children via [View.showRendering](../com.squareup.workflow.ui/android.view.-view/show-rendering.md) et al.
Allows container views to give descendants information about the context in which
they're drawing.


| (extensions in package com.squareup.workflow.ui)

##### [android.content.Context](../com.squareup.workflow.ui/android.content.-context/index.md)


| (extensions in package com.squareup.workflow.ui)

##### [androidx.fragment.app.FragmentActivity](../com.squareup.workflow.ui/androidx.fragment.app.-fragment-activity/index.md)


|

##### [com.squareup.workflow.ui.LayoutRunner](../com.squareup.workflow.ui/-layout-runner/index.md)

A delegate that implements a [showRendering](../com.squareup.workflow.ui/-layout-runner/show-rendering.md) method to be called when a workflow rendering
of type [RenderingT](../com.squareup.workflow.ui/-layout-runner/index.md#RenderingT) is ready to be displayed in a view inflated from a layout resource
by a [ViewRegistry](../com.squareup.workflow.ui/-view-registry/index.md). (Use [BuilderBinding](../com.squareup.workflow.ui/-builder-binding/index.md) if you want to build views from code rather
than layouts.)


|

##### [com.squareup.workflow.ui.ModalContainer](../com.squareup.workflow.ui/-modal-container/index.md)

Base class for containers that show [HasModals.modals](#) in [Dialog](https://developer.android.com/reference/android/app/Dialog.html) windows.


|

##### [com.squareup.workflow.ui.ModalViewContainer](../com.squareup.workflow.ui/-modal-view-container/index.md)

Container that shows [HasModals.modals](#) as arbitrary views in a [Dialog](https://developer.android.com/reference/android/app/Dialog.html)
window. Provides compatibility with [View.backPressedHandler](../com.squareup.workflow.ui/android.view.-view/back-pressed-handler.md).


|

##### [com.squareup.workflow.ui.ShowRenderingTag](../com.squareup.workflow.ui/-show-rendering-tag/index.md)

` * View tag that holds the function to make the view show instances of [RenderingT](../com.squareup.workflow.ui/-show-rendering-tag/index.md#RenderingT), and
the [current rendering](../com.squareup.workflow.ui/-show-rendering-tag/showing.md).


| (extensions in package com.squareup.workflow.ui)

##### [android.view.View](../com.squareup.workflow.ui/android.view.-view/index.md)


|

##### [com.squareup.workflow.ui.ViewBinding](../com.squareup.workflow.ui/-view-binding/index.md)

Factory for [View](https://developer.android.com/reference/android/view/View.html) instances that can show renderings of type[RenderingT](../com.squareup.workflow.ui/-view-binding/index.md#RenderingT).
Use [LayoutRunner.bind](../com.squareup.workflow.ui/-layout-runner/bind.md) to work with XML layout resources, or
[BuilderBinding](../com.squareup.workflow.ui/-builder-binding/index.md) to create views from code.


|

##### [com.squareup.workflow.ui.ViewRegistry](../com.squareup.workflow.ui/-view-registry/index.md)

A collection of [ViewBinding](../com.squareup.workflow.ui/-view-binding/index.md)s that can be used to display the stream of renderings
from a workflow tree.


|

##### [com.squareup.workflow.ui.ViewShowRendering](../com.squareup.workflow.ui/-view-show-rendering.md)

Function attached to a view created by [ViewRegistry](../com.squareup.workflow.ui/-view-registry/index.md), to allow it
to respond to [View.showRendering](../com.squareup.workflow.ui/android.view.-view/show-rendering.md).


|

##### [com.squareup.workflow.ui.backstack.ViewStateCache](../com.squareup.workflow.ui.backstack/-view-state-cache/index.md)

Handles persistence chores for container views that manage a set of [Named](#) renderings,
showing a view for one at a time -- think back stacks or tab sets.


|

##### [com.squareup.workflow.ui.WorkflowFragment](../com.squareup.workflow.ui/-workflow-fragment/index.md)

A [Fragment](#) that can run a workflow. Subclasses implement [onCreateWorkflow](../com.squareup.workflow.ui/-workflow-fragment/on-create-workflow.md)
to configure themselves with a [Workflow](#), [ViewRegistry](../com.squareup.workflow.ui/-view-registry/index.md) and [inputs](#).


|

##### [com.squareup.workflow.ui.WorkflowLayout](../com.squareup.workflow.ui/-workflow-layout/index.md)

A view that can be driven by a [WorkflowRunner](../com.squareup.workflow.ui/-workflow-runner/index.md). In most cases you'll use
[Activity.setContentWorkflow](../com.squareup.workflow.ui/androidx.fragment.app.-fragment-activity/set-content-workflow.md) or subclass [WorkflowFragment](../com.squareup.workflow.ui/-workflow-fragment/index.md)
rather than manage this class directly.


|

##### [com.squareup.workflow.ui.WorkflowRunner](../com.squareup.workflow.ui/-workflow-runner/index.md)

Uses a [Workflow](#) and a [ViewRegistry](../com.squareup.workflow.ui/-view-registry/index.md) to drive a [WorkflowLayout](../com.squareup.workflow.ui/-workflow-layout/index.md).


|

##### [com.squareup.workflow.ui.WorkflowViewStub](../com.squareup.workflow.ui/-workflow-view-stub/index.md)

A placeholder [View](https://developer.android.com/reference/android/view/View.html) that can replace itself with ones driven by workflow renderings,
similar to [android.view.ViewStub](https://developer.android.com/reference/android/view/ViewStub.html).


