[workflow-ui-android](../../index.md) / [com.squareup.workflow.ui.backstack](../index.md) / [ViewStateCache](./index.md)

# ViewStateCache

`class ViewStateCache : `[`Parcelable`](https://developer.android.com/reference/android/os/Parcelable.html)

Handles persistence chores for container views that manage a set of [Named](#) renderings,
showing a view for one at a time -- think back stacks or tab sets.

This class implements [Parcelable](https://developer.android.com/reference/android/os/Parcelable.html) so that it can be preserved from
a container view's own [View.saveHierarchyState](https://developer.android.com/reference/android/view/View.html#saveHierarchyState(android.util.SparseArray<android.os.Parcelable>)) method. A simple container can
return [SavedState](-saved-state/index.md) from that method rather than creating its own persistence class.

### Types

| Name | Summary |
|---|---|
| [CREATOR](-c-r-e-a-t-o-r/index.md) | `companion object CREATOR : `[`Creator`](https://developer.android.com/reference/android/os/Parcelable/Creator.html)`<`[`ViewStateCache`](./index.md)`>` |
| [SavedState](-saved-state/index.md) | Convenience for use in [View.onSaveInstanceState](https://developer.android.com/reference/android/view/View.html#onSaveInstanceState()) and [View.onRestoreInstanceState](https://developer.android.com/reference/android/view/View.html#onRestoreInstanceState(android.os.Parcelable)) methods of container views that have no other state of their own to save.`class SavedState : `[`BaseSavedState`](https://developer.android.com/reference/android/view/View/BaseSavedState.html) |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `ViewStateCache()` |

### Functions

| Name | Summary |
|---|---|
| [describeContents](describe-contents.md) | `fun describeContents(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [prune](prune.md) | To be called when the set of hidden views changes but the visible view remains the same. Any cached view state held for renderings that are not [compatible](#) those in [retaining](prune.md#com.squareup.workflow.ui.backstack.ViewStateCache$prune(kotlin.collections.Collection((com.squareup.workflow.ui.Named((kotlin.Any)))))/retaining) will be dropped.`fun prune(retaining: `[`Collection`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-collection/index.html)`<Named<*>>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [restore](restore.md) | Replaces the state of the receiver with that of [from](restore.md#com.squareup.workflow.ui.backstack.ViewStateCache$restore(com.squareup.workflow.ui.backstack.ViewStateCache)/from). Typical usage is to call this from a container view's [View.onRestoreInstanceState](https://developer.android.com/reference/android/view/View.html#onRestoreInstanceState(android.os.Parcelable)).`fun restore(from: `[`ViewStateCache`](./index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [update](update.md) | `fun update(retainedRenderings: `[`Collection`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-collection/index.html)`<Named<*>>, oldViewMaybe: `[`View`](https://developer.android.com/reference/android/view/View.html)`?, newView: `[`View`](https://developer.android.com/reference/android/view/View.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [writeToParcel](write-to-parcel.md) | `fun writeToParcel(parcel: `[`Parcel`](https://developer.android.com/reference/android/os/Parcel.html)`, flags: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [createFromParcel](create-from-parcel.md) | `fun createFromParcel(parcel: `[`Parcel`](https://developer.android.com/reference/android/os/Parcel.html)`): `[`ViewStateCache`](./index.md) |
| [newArray](new-array.md) | `fun newArray(size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Array`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)`<`[`ViewStateCache`](./index.md)`?>` |
