[workflow-ui-android](../../index.md) / [com.squareup.workflow.ui](../index.md) / [BuilderBinding](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`BuilderBinding(type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<RenderingT>, viewConstructor: (initialRendering: RenderingT, initialContainerHints: `[`ContainerHints`](../-container-hints/index.md)`, contextForNewView: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, container: `[`ViewGroup`](https://developer.android.com/reference/android/view/ViewGroup.html)`?) -> `[`View`](https://developer.android.com/reference/android/view/View.html)`)`

A [ViewBinding](../-view-binding/index.md) that allows a [ViewRegistry](../-view-registry/index.md) to create [View](https://developer.android.com/reference/android/view/View.html)s that need
to be generated from code. (Use [LayoutRunner](../-layout-runner/index.md) to work with XML layout resources.)

Typical usage is to have a custom builder or view's `companion object` implement
[ViewBinding](../-view-binding/index.md) by delegating to a [BuilderBinding](index.md), like this:

```
    class MyView(
      context: Context,
      attributeSet: AttributeSet?
    ) : FrameLayout(context, attributeSet) {
      private fun update(rendering:  MyRendering) { ... }

      companion object : ViewBuilder<MyScreen>
      by BuilderBinding(
          type = MyScreen::class,
          builder = { _, initialRendering, context, _ ->
            MyView(context).apply {
              layoutParams = ViewGroup.LayoutParams(MATCH_PARENT, MATCH_PARENT)
              bindShowRendering(initialRendering, ::update)
            }
      )
    }
```

This pattern allows us to assemble a [ViewRegistry](../-view-registry/index.md) out of the
custom classes themselves.

```
    val TicTacToeViewBuilders = ViewRegistry(
        MyView, GamePlayLayoutRunner, GameOverLayoutRunner
    )
```

