[workflow-ui-android](../../index.md) / [com.squareup.workflow.ui](../index.md) / [ContainerHints](./index.md)

# ContainerHints

`class ContainerHints`

Immutable, append-only map of values that a parent view can pass down to
its children via [View.showRendering](../android.view.-view/show-rendering.md) et al.
Allows container views to give descendants information about the context in which
they're drawing.

Every [ContainerHints](./index.md) includes a [ViewRegistry](../-view-registry/index.md). This allows container views to
make recursive [ViewRegistry.buildView](../-view-registry/build-view.md) calls to build child views to show nested renderings.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `ContainerHints(registry: `[`ViewRegistry`](../-view-registry/index.md)`)` |

### Functions

| Name | Summary |
|---|---|
| [equals](equals.md) | `fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [get](get.md) | `operator fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> get(key: `[`ContainerHintKey`](../-container-hint-key/index.md)`<T>): T` |
| [hashCode](hash-code.md) | `fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [plus](plus.md) | `operator fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> plus(pair: `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<`[`ContainerHintKey`](../-container-hint-key/index.md)`<T>, T>): `[`ContainerHints`](./index.md)<br>`operator fun plus(other: `[`ContainerHints`](./index.md)`): `[`ContainerHints`](./index.md) |
| [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
