[workflow-ui-android](../../index.md) / [com.squareup.workflow.ui](../index.md) / [LayoutRunner](./index.md)

# LayoutRunner

`interface LayoutRunner<RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`

A delegate that implements a [showRendering](show-rendering.md) method to be called when a workflow rendering
of type [RenderingT](index.md#RenderingT) is ready to be displayed in a view inflated from a layout resource
by a [ViewRegistry](../-view-registry/index.md). (Use [BuilderBinding](../-builder-binding/index.md) if you want to build views from code rather
than layouts.)

Typical usage is to have a [LayoutRunner](./index.md)'s `companion object` implement
[ViewBinding](../-view-binding/index.md) by delegating to [LayoutRunner.bind](bind.md), specifying the layout resource
it expects to drive.

class HelloLayoutRunner(view: View) : LayoutRunner {
    private val messageView: TextView = view.findViewById(R.id.hello_message)

```
    override fun showRendering(rendering: Rendering) {
      messageView.text = rendering.message
      messageView.setOnClickListener { rendering.onClick(Unit) }
    }

    companion object : ViewBinding<Rendering> by bind(
        R.layout.hello_goodbye_layout, ::HelloLayoutRunner
    )
```

}

This pattern allows us to assemble a [ViewRegistry](../-view-registry/index.md) out of the [LayoutRunner](./index.md) classes
themselves.

```
    val TicTacToeViewBuilders = ViewRegistry(
        NewGameLayoutRunner, GamePlayLayoutRunner, GameOverLayoutRunner
    )
```

### Types

| Name | Summary |
|---|---|
| [Binding](-binding/index.md) | `class Binding<RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`ViewBinding`](../-view-binding/index.md)`<RenderingT>` |

### Functions

| Name | Summary |
|---|---|
| [showRendering](show-rendering.md) | `abstract fun showRendering(rendering: RenderingT, containerHints: `[`ContainerHints`](../-container-hints/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [bind](bind.md) | Creates a [ViewBinding](../-view-binding/index.md) that inflates [layoutId](bind.md#com.squareup.workflow.ui.LayoutRunner.Companion$bind(kotlin.Int, kotlin.Function1((android.view.View, com.squareup.workflow.ui.LayoutRunner((com.squareup.workflow.ui.LayoutRunner.Companion.bind.RenderingT)))))/layoutId) to show renderings of type [RenderingT](bind.md#RenderingT), using a [LayoutRunner](./index.md) created by [constructor](bind.md#com.squareup.workflow.ui.LayoutRunner.Companion$bind(kotlin.Int, kotlin.Function1((android.view.View, com.squareup.workflow.ui.LayoutRunner((com.squareup.workflow.ui.LayoutRunner.Companion.bind.RenderingT)))))/constructor).`fun <RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> bind(layoutId: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, constructor: (`[`View`](https://developer.android.com/reference/android/view/View.html)`) -> `[`LayoutRunner`](./index.md)`<RenderingT>): `[`ViewBinding`](../-view-binding/index.md)`<RenderingT>` |
| [bindNoRunner](bind-no-runner.md) | Creates a [ViewBinding](../-view-binding/index.md) that inflates [layoutId](bind-no-runner.md#com.squareup.workflow.ui.LayoutRunner.Companion$bindNoRunner(kotlin.Int)/layoutId) to "show" renderings of type [RenderingT](bind-no-runner.md#RenderingT), with a no-op [LayoutRunner](./index.md). Handy for showing static views.`fun <RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> bindNoRunner(layoutId: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`ViewBinding`](../-view-binding/index.md)`<RenderingT>` |
