[workflow-ui-android](../../index.md) / [com.squareup.workflow.ui](../index.md) / [ModalContainer](index.md) / [forContainerScreen](./for-container-screen.md)

# forContainerScreen

`inline fun <reified H : HasModals<*, *>> forContainerScreen(@IdRes id: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, @StyleRes dialogThemeResId: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0, noinline modalDecorator: (`[`View`](https://developer.android.com/reference/android/view/View.html)`) -> `[`View`](https://developer.android.com/reference/android/view/View.html)` = { it }): `[`ViewBinding`](../-view-binding/index.md)`<`[`H`](for-container-screen.md#H)`>`

Creates a [ViewBinding](../-view-binding/index.md) for modal container screens of type [H](for-container-screen.md#H).

Each view created for [HasModals.modals](#) will be shown in a [Dialog](https://developer.android.com/reference/android/app/Dialog.html)
whose window is set to size itself to `WRAP_CONTENT` (see [android.view.Window.setLayout](https://developer.android.com/reference/android/view/Window.html#setLayout(int, int))).
Two customization hooks are provided: you can specify a [theme](for-container-screen.md#com.squareup.workflow.ui.ModalContainer.Companion$forContainerScreen(kotlin.Int, kotlin.Int, kotlin.Function1((android.view.View, )))/dialogThemeResId) to be
applied to the dialog window; and/or provide a [function](for-container-screen.md#com.squareup.workflow.ui.ModalContainer.Companion$forContainerScreen(kotlin.Int, kotlin.Int, kotlin.Function1((android.view.View, )))/modalDecorator) to decorate
the view to set as the [dialog's content](https://developer.android.com/reference/android/app/Dialog.html#setContentView(int)).

### Parameters

`id` - a unique identifier for containers of this type, allowing them to participate
view persistence

`dialogThemeResId` - a style resource describing the theme to use for dialog
windows. Defaults to `0` to use the default dialog theme.

`modalDecorator` - a function to apply to each [modal](#) view
created before it is passed to [android.app.Dialog.setContentView](https://developer.android.com/reference/android/app/Dialog.html#setContentView(int)).
Defaults to making no changes.