[workflow-ui-android](../../index.md) / [com.squareup.workflow.ui](../index.md) / [ModalContainer](./index.md)

# ModalContainer

`abstract class ModalContainer<ModalRenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`FrameLayout`](https://developer.android.com/reference/android/widget/FrameLayout.html)

Base class for containers that show [HasModals.modals](#) in [Dialog](https://developer.android.com/reference/android/app/Dialog.html) windows.

### Parameters

`ModalRenderingT` - the type of the nested renderings to be shown in a dialog window.

### Types

| Name | Summary |
|---|---|
| [DialogRef](-dialog-ref/index.md) | `data class DialogRef<ModalRenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | Base class for containers that show [HasModals.modals](#) in [Dialog](https://developer.android.com/reference/android/app/Dialog.html) windows.`ModalContainer(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, attributeSet: `[`AttributeSet`](https://developer.android.com/reference/android/util/AttributeSet.html)`? = null, defStyle: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0, defStyleRes: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0)` |

### Functions

| Name | Summary |
|---|---|
| [buildDialog](build-dialog.md) | Called to create (but not show) a Dialog to render [initialModalRendering](build-dialog.md#com.squareup.workflow.ui.ModalContainer$buildDialog(com.squareup.workflow.ui.ModalContainer.ModalRenderingT, com.squareup.workflow.ui.ContainerHints)/initialModalRendering).`abstract fun buildDialog(initialModalRendering: ModalRenderingT, initialContainerHints: `[`ContainerHints`](../-container-hints/index.md)`): DialogRef<ModalRenderingT>` |
| [onRestoreInstanceState](on-restore-instance-state.md) | `open fun onRestoreInstanceState(state: `[`Parcelable`](https://developer.android.com/reference/android/os/Parcelable.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onSaveInstanceState](on-save-instance-state.md) | `open fun onSaveInstanceState(): `[`Parcelable`](https://developer.android.com/reference/android/os/Parcelable.html) |
| [update](update.md) | `fun update(newScreen: HasModals<*, ModalRenderingT>, containerHints: `[`ContainerHints`](../-container-hints/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [updateDialog](update-dialog.md) | `abstract fun updateDialog(dialogRef: DialogRef<ModalRenderingT>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Inheritors

| Name | Summary |
|---|---|
| [AlertContainer](../-alert-container/index.md) | Renders the [AlertScreen](#)s of an [AlertContainerScreen](#) as [AlertDialog](#)s.`class AlertContainer : `[`ModalContainer`](./index.md)`<AlertScreen>` |
| [ModalViewContainer](../-modal-view-container/index.md) | Container that shows [HasModals.modals](#) as arbitrary views in a [Dialog](https://developer.android.com/reference/android/app/Dialog.html) window. Provides compatibility with [View.backPressedHandler](../android.view.-view/back-pressed-handler.md).`open class ModalViewContainer : `[`ModalContainer`](./index.md)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
