[workflow-ui-android](../../index.md) / [com.squareup.workflow.ui](../index.md) / [ModalViewContainer](./index.md)

# ModalViewContainer

`open class ModalViewContainer : `[`ModalContainer`](../-modal-container/index.md)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`

Container that shows [HasModals.modals](#) as arbitrary views in a [Dialog](https://developer.android.com/reference/android/app/Dialog.html)
window. Provides compatibility with [View.backPressedHandler](../android.view.-view/back-pressed-handler.md).

Use [binding](binding.md) to assign particular rendering types to be shown this way.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | Container that shows [HasModals.modals](#) as arbitrary views in a [Dialog](https://developer.android.com/reference/android/app/Dialog.html) window. Provides compatibility with [View.backPressedHandler](../android.view.-view/back-pressed-handler.md).`ModalViewContainer(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, attributeSet: `[`AttributeSet`](https://developer.android.com/reference/android/util/AttributeSet.html)`? = null, defStyle: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0, defStyleRes: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0)` |

### Functions

| Name | Summary |
|---|---|
| [buildDialog](build-dialog.md) | Called to create (but not show) a Dialog to render [initialModalRendering](../-modal-container/build-dialog.md#com.squareup.workflow.ui.ModalContainer$buildDialog(com.squareup.workflow.ui.ModalContainer.ModalRenderingT, com.squareup.workflow.ui.ContainerHints)/initialModalRendering).`fun buildDialog(initialModalRendering: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, initialContainerHints: `[`ContainerHints`](../-container-hints/index.md)`): DialogRef<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
| [buildDialogForView](build-dialog-for-view.md) | Called from [buildDialog](build-dialog.md). Builds (but does not show) the [Dialog](https://developer.android.com/reference/android/app/Dialog.html) to display a [view](build-dialog-for-view.md#com.squareup.workflow.ui.ModalViewContainer$buildDialogForView(android.view.View)/view) built via [ViewRegistry](../-view-registry/index.md).`open fun buildDialogForView(view: `[`View`](https://developer.android.com/reference/android/view/View.html)`): `[`Dialog`](https://developer.android.com/reference/android/app/Dialog.html) |
| [updateDialog](update-dialog.md) | `open fun updateDialog(dialogRef: DialogRef<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [binding](binding.md) | Creates a [ViewBinding](../-view-binding/index.md) for modal container screens of type [H](binding.md#H).`fun <H : HasModals<*, *>> binding(id: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = View.NO_ID): `[`ViewBinding`](../-view-binding/index.md)`<H>` |
