[workflow-ui-android](../../index.md) / [com.squareup.workflow.ui](../index.md) / [ViewBinding](./index.md)

# ViewBinding

`interface ViewBinding<RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`

Factory for [View](https://developer.android.com/reference/android/view/View.html) instances that can show renderings of type[RenderingT](index.md#RenderingT).
Use [LayoutRunner.bind](../-layout-runner/bind.md) to work with XML layout resources, or
[BuilderBinding](../-builder-binding/index.md) to create views from code.

Sets of bindings are gathered in [ViewRegistry](../-view-registry/index.md) instances.

### Properties

| Name | Summary |
|---|---|
| [type](type.md) | `abstract val type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<RenderingT>` |

### Functions

| Name | Summary |
|---|---|
| [buildView](build-view.md) | Returns a View ready to display [initialRendering](build-view.md#com.squareup.workflow.ui.ViewBinding$buildView(com.squareup.workflow.ui.ViewBinding.RenderingT, com.squareup.workflow.ui.ContainerHints, android.content.Context, android.view.ViewGroup)/initialRendering) (and any succeeding values) via [View.showRendering](../android.view.-view/show-rendering.md).`abstract fun buildView(initialRendering: RenderingT, initialContainerHints: `[`ContainerHints`](../-container-hints/index.md)`, contextForNewView: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, container: `[`ViewGroup`](https://developer.android.com/reference/android/view/ViewGroup.html)`? = null): `[`View`](https://developer.android.com/reference/android/view/View.html) |

### Inheritors

| Name | Summary |
|---|---|
| [BuilderBinding](../-builder-binding/index.md) | A [ViewBinding](./index.md) that allows a [ViewRegistry](../-view-registry/index.md) to create [View](https://developer.android.com/reference/android/view/View.html)s that need to be generated from code. (Use [LayoutRunner](../-layout-runner/index.md) to work with XML layout resources.)`class BuilderBinding<RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`ViewBinding`](./index.md)`<RenderingT>` |
