[workflow-ui-android](../../index.md) / [com.squareup.workflow.ui](../index.md) / [ViewRegistry](./index.md)

# ViewRegistry

`interface ViewRegistry`

A collection of [ViewBinding](../-view-binding/index.md)s that can be used to display the stream of renderings
from a workflow tree.

Two concrete [ViewBinding](../-view-binding/index.md) implementations are provided:

* [LayoutRunner.Binding](../-layout-runner/-binding/index.md), allowing the easy pairing of Android XML layout resources with
    [LayoutRunner](../-layout-runner/index.md)s to drive them.

* [BuilderBinding](../-builder-binding/index.md), which can build views from code.

Registries can be assembled via concatenation, making it easy to snap together screen sets.
For example:

```
    val AuthViewBindings = ViewRegistry(
        AuthorizingLayoutRunner, LoginLayoutRunner, SecondFactorLayoutRunner
    )

    val TicTacToeViewBindings = ViewRegistry(
        NewGameLayoutRunner, GamePlayLayoutRunner, GameOverLayoutRunner
    )

    val ApplicationViewBindings = ViewRegistry(ApplicationLayoutRunner) +
        AuthViewBindings + TicTacToeViewBindings
```

In the above example, note that the `companion object`s of the various [LayoutRunner](../-layout-runner/index.md) classes
honor a convention of implementing [ViewBinding](../-view-binding/index.md), in aid of this kind of assembly. See the
class doc on [LayoutRunner](../-layout-runner/index.md) for details.

Default bindings for the following types are provided, but can be overridden:

* [Named](#)`<*>` (Delegates to the registered binding for [Named.wrapped](#).)
* [BackStackScreen](#)`<*>`
* [AlertContainerScreen](#)`<*>` (Use [ModalContainer.binding](#) to set
    a different dialog theme.)

### Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | `companion object Companion : `[`ContainerHintKey`](../-container-hint-key/index.md)`<`[`ViewRegistry`](./index.md)`>` |

### Properties

| Name | Summary |
|---|---|
| [keys](keys.md) | The set of unique keys which this registry can derive from the renderings passed to [buildView](build-view.md) and for which it knows how to create views.`abstract val keys: `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |

### Functions

| Name | Summary |
|---|---|
| [buildView](build-view.md) | It is usually more convenient to use [WorkflowViewStub](../-workflow-view-stub/index.md) than to call this method directly.`abstract fun <RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> buildView(initialRendering: RenderingT, initialContainerHints: `[`ContainerHints`](../-container-hints/index.md)`, contextForNewView: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, container: `[`ViewGroup`](https://developer.android.com/reference/android/view/ViewGroup.html)`? = null): `[`View`](https://developer.android.com/reference/android/view/View.html) |

### Companion Object Properties

| Name | Summary |
|---|---|
| [default](default.md) | `val default: `[`ViewRegistry`](./index.md) |

### Extension Functions

| Name | Summary |
|---|---|
| [buildView](../build-view.md) | It is usually more convenient to use [WorkflowViewStub](../-workflow-view-stub/index.md) than to call this method directly.`fun <RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> `[`ViewRegistry`](./index.md)`.buildView(initialRendering: RenderingT, initialContainerHints: `[`ContainerHints`](../-container-hints/index.md)`, container: `[`ViewGroup`](https://developer.android.com/reference/android/view/ViewGroup.html)`): `[`View`](https://developer.android.com/reference/android/view/View.html) |
| [plus](../plus.md) | `operator fun `[`ViewRegistry`](./index.md)`.plus(binding: `[`ViewBinding`](../-view-binding/index.md)`<*>): `[`ViewRegistry`](./index.md)<br>`operator fun `[`ViewRegistry`](./index.md)`.plus(other: `[`ViewRegistry`](./index.md)`): `[`ViewRegistry`](./index.md) |
