[workflow-ui-android](../../index.md) / [com.squareup.workflow.ui](../index.md) / [WorkflowFragment](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`WorkflowFragment()`

A [Fragment](#) that can run a workflow. Subclasses implement [onCreateWorkflow](on-create-workflow.md)
to configure themselves with a [Workflow](#), [ViewRegistry](../-view-registry/index.md) and [inputs](#).

For a workflow with no inputs, or a static configuration, that's as simple as:

```
    class HelloWorkflowFragment : WorkflowFragment<Unit, Unit>() {
      override fun onCreateWorkflow(): Config<Unit, Unit> {
        return Config(
            workflow = HelloWorkflow,
            input = Unit
        )
      }
    }
```

A fragment to run a workflow whose configuration may need to be updated could
provide a method like this:

class HelloWorkflowFragment : WorkflowFragment&lt;HelloInput, Unit&gt;() {
    private val inputs = BehaviorSubject.createDefault(HelloInput.Fnord)

```
    fun input(input: HelloInput) = inputs.onNext(input)

    override fun onCreateWorkflow(): Config<HelloInput, Unit> {
      return Config(
          workflow = HelloWorkflow,
          inputs = inputs
      )
    }
```

}

