[workflow-ui-android](../../index.md) / [com.squareup.workflow.ui](../index.md) / [WorkflowFragment](./index.md)

# WorkflowFragment

`abstract class WorkflowFragment<PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : Fragment`

A [Fragment](#) that can run a workflow. Subclasses implement [onCreateWorkflow](on-create-workflow.md)
to configure themselves with a [Workflow](#), [ViewRegistry](../-view-registry/index.md) and [inputs](#).

For a workflow with no inputs, or a static configuration, that's as simple as:

```
    class HelloWorkflowFragment : WorkflowFragment<Unit, Unit>() {
      override fun onCreateWorkflow(): Config<Unit, Unit> {
        return Config(
            workflow = HelloWorkflow,
            input = Unit
        )
      }
    }
```

A fragment to run a workflow whose configuration may need to be updated could
provide a method like this:

class HelloWorkflowFragment : WorkflowFragment&lt;HelloInput, Unit&gt;() {
    private val inputs = BehaviorSubject.createDefault(HelloInput.Fnord)

```
    fun input(input: HelloInput) = inputs.onNext(input)

    override fun onCreateWorkflow(): Config<HelloInput, Unit> {
      return Config(
          workflow = HelloWorkflow,
          inputs = inputs
      )
    }
```

}

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | A [Fragment](#) that can run a workflow. Subclasses implement [onCreateWorkflow](on-create-workflow.md) to configure themselves with a [Workflow](#), [ViewRegistry](../-view-registry/index.md) and [inputs](#).`WorkflowFragment()` |

### Properties

| Name | Summary |
|---|---|
| [containerHints](container-hints.md) | Provides the [ViewRegistry](../-view-registry/index.md) used to display workflow renderings.`abstract val containerHints: `[`ContainerHints`](../-container-hints/index.md) |
| [runner](runner.md) | Provides subclasses with access to the products of the running [Workflow](#). Safe to call after [onActivityCreated](on-activity-created.md).`val runner: `[`WorkflowRunner`](../-workflow-runner/index.md)`<OutputT>` |

### Functions

| Name | Summary |
|---|---|
| [onActivityCreated](on-activity-created.md) | `open fun onActivityCreated(savedInstanceState: `[`Bundle`](https://developer.android.com/reference/android/os/Bundle.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onCreateView](on-create-view.md) | `fun onCreateView(inflater: `[`LayoutInflater`](https://developer.android.com/reference/android/view/LayoutInflater.html)`, container: `[`ViewGroup`](https://developer.android.com/reference/android/view/ViewGroup.html)`?, savedInstanceState: `[`Bundle`](https://developer.android.com/reference/android/os/Bundle.html)`?): `[`WorkflowLayout`](../-workflow-layout/index.md) |
| [onCreateWorkflow](on-create-workflow.md) | Called from [onActivityCreated](on-activity-created.md), so it should be safe for implementations to call [getActivity](#).`abstract fun onCreateWorkflow(): Config<PropsT, OutputT>` |
