[workflow-ui-android](../../index.md) / [com.squareup.workflow.ui](../index.md) / [WorkflowRunner](./index.md)

# WorkflowRunner

`interface WorkflowRunner<out OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`

Uses a [Workflow](#) and a [ViewRegistry](../-view-registry/index.md) to drive a [WorkflowLayout](../-workflow-layout/index.md).

It is simplest to use [Activity.setContentWorkflow](../androidx.fragment.app.-fragment-activity/set-content-workflow.md)
or subclass [WorkflowFragment](../-workflow-fragment/index.md) rather than instantiate a [WorkflowRunner](./index.md) directly.

### Types

| Name | Summary |
|---|---|
| [Config](-config/index.md) | `class Config<PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |

### Properties

| Name | Summary |
|---|---|
| [renderings](renderings.md) | A stream of the rendering values emitted by the running [Workflow](#).`abstract val renderings: Observable<out `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
| [result](result.md) | Provides the first (and only) [OutputT](index.md#OutputT) value emitted by the workflow, or nothing if it is canceled before emitting.`abstract val result: Maybe<out OutputT>` |

### Companion Object Functions

| Name | Summary |
|---|---|
| [Config](-config.md) | `fun <OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> Config(workflow: Workflow<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, OutputT, `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>, dispatcher: CoroutineDispatcher = Dispatchers.Main.immediate, diagnosticListener: WorkflowDiagnosticListener? = null): Config<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, OutputT>` |
| [startWorkflow](start-workflow.md) | Returns an instance of [WorkflowRunner](./index.md) tied to the [Lifecycle](#) of the given [activity](start-workflow.md#com.squareup.workflow.ui.WorkflowRunner.Companion$startWorkflow(androidx.fragment.app.FragmentActivity, kotlin.Function0((com.squareup.workflow.ui.WorkflowRunner.Config((com.squareup.workflow.ui.WorkflowRunner.Companion.startWorkflow.PropsT, com.squareup.workflow.ui.WorkflowRunner.Companion.startWorkflow.OutputT)))))/activity).`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> startWorkflow(activity: FragmentActivity, configure: () -> Config<PropsT, OutputT>): `[`WorkflowRunner`](./index.md)`<OutputT>`<br>Returns an instance of [WorkflowRunner](./index.md) tied to the [Lifecycle](#) of the given [fragment](start-workflow.md#com.squareup.workflow.ui.WorkflowRunner.Companion$startWorkflow(androidx.fragment.app.Fragment, kotlin.Function0((com.squareup.workflow.ui.WorkflowRunner.Config((com.squareup.workflow.ui.WorkflowRunner.Companion.startWorkflow.PropsT, com.squareup.workflow.ui.WorkflowRunner.Companion.startWorkflow.OutputT)))))/fragment).`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> startWorkflow(fragment: Fragment, configure: () -> Config<PropsT, OutputT>): `[`WorkflowRunner`](./index.md)`<OutputT>` |
