[workflow-ui-android](../../index.md) / [com.squareup.workflow.ui](../index.md) / [WorkflowViewStub](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`WorkflowViewStub(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, attributeSet: `[`AttributeSet`](https://developer.android.com/reference/android/util/AttributeSet.html)`? = null, defStyle: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0, defStyleRes: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0)`

A placeholder [View](https://developer.android.com/reference/android/view/View.html) that can replace itself with ones driven by workflow renderings,
similar to [android.view.ViewStub](https://developer.android.com/reference/android/view/ViewStub.html).

## Usage

In the XML layout for a container view, place a [WorkflowViewStub](index.md) where
you want child renderings to be displayed. E.g.:

```
    <LinearLayout…>

        <com.squareup.workflow.ui.WorkflowViewStub
            android:id="@+id/child_stub"
            />
       …
```

Then in your [LayoutRunner](../-layout-runner/index.md),

* pull the view out with `findViewById` like any other view
* and update it in your `showRendering` method:

```
    class YourLayoutRunner(view: View) {
      private val child = view.findViewById<WorkflowViewStub>(R.id.child_stub)

      override fun showRendering(
         rendering: YourRendering,
         containerHints: ContainerHints
      ) {
        child.update(rendering.childRendering, containerHints)
      }
    }
```

