[workflow-ui-android](../../index.md) / [com.squareup.workflow.ui](../index.md) / [WorkflowViewStub](./index.md)

# WorkflowViewStub

`class WorkflowViewStub : `[`View`](https://developer.android.com/reference/android/view/View.html)

A placeholder [View](https://developer.android.com/reference/android/view/View.html) that can replace itself with ones driven by workflow renderings,
similar to [android.view.ViewStub](https://developer.android.com/reference/android/view/ViewStub.html).

## Usage

In the XML layout for a container view, place a [WorkflowViewStub](./index.md) where
you want child renderings to be displayed. E.g.:

```
    <LinearLayout…>

        <com.squareup.workflow.ui.WorkflowViewStub
            android:id="@+id/child_stub"
            />
       …
```

Then in your [LayoutRunner](../-layout-runner/index.md),

* pull the view out with `findViewById` like any other view
* and update it in your `showRendering` method:

```
    class YourLayoutRunner(view: View) {
      private val child = view.findViewById<WorkflowViewStub>(R.id.child_stub)

      override fun showRendering(
         rendering: YourRendering,
         containerHints: ContainerHints
      ) {
        child.update(rendering.childRendering, containerHints)
      }
    }
```

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | A placeholder [View](https://developer.android.com/reference/android/view/View.html) that can replace itself with ones driven by workflow renderings, similar to [android.view.ViewStub](https://developer.android.com/reference/android/view/ViewStub.html).`WorkflowViewStub(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, attributeSet: `[`AttributeSet`](https://developer.android.com/reference/android/util/AttributeSet.html)`? = null, defStyle: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0, defStyleRes: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0)` |

### Properties

| Name | Summary |
|---|---|
| [actual](actual.md) | On-demand access to the delegate established by the last call to [update](update.md), or this [WorkflowViewStub](./index.md) instance if  none has yet been set.`var actual: `[`View`](https://developer.android.com/reference/android/view/View.html) |

### Functions

| Name | Summary |
|---|---|
| [update](update.md) | Replaces this view with one that can display [rendering](update.md#com.squareup.workflow.ui.WorkflowViewStub$update(kotlin.Any, com.squareup.workflow.ui.ContainerHints)/rendering). If the receiver has already been replaced, updates the replacement if it [canShowRendering](../android.view.-view/can-show-rendering.md). If the current replacement can't handle [rendering](update.md#com.squareup.workflow.ui.WorkflowViewStub$update(kotlin.Any, com.squareup.workflow.ui.ContainerHints)/rendering), a new view is put in place.`fun update(rendering: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, containerHints: `[`ContainerHints`](../-container-hints/index.md)`): `[`View`](https://developer.android.com/reference/android/view/View.html) |
