[workflow-ui-android](../../index.md) / [com.squareup.workflow.ui](../index.md) / [android.view.View](./index.md)

### Extensions for android.view.View

| Name | Summary |
|---|---|
| [backPressedHandler](back-pressed-handler.md) | A function to be called if the device back button is pressed while this view is attached to a window.`var `[`View`](https://developer.android.com/reference/android/view/View.html)`.backPressedHandler: `[`BackPressHandler`](../-back-press-handler.md)`?` |
| [bindShowRendering](bind-show-rendering.md) | It is usually more convenient to use [WorkflowViewStub](../-workflow-view-stub/index.md) than to call this method directly.`fun <RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> `[`View`](https://developer.android.com/reference/android/view/View.html)`.bindShowRendering(initialRendering: RenderingT, initialContainerHints: `[`ContainerHints`](../-container-hints/index.md)`, showRendering: `[`ViewShowRendering`](../-view-show-rendering.md)`<RenderingT>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [canShowRendering](can-show-rendering.md) | It is usually more convenient to use [WorkflowViewStub](../-workflow-view-stub/index.md) than to call this method directly.`fun `[`View`](https://developer.android.com/reference/android/view/View.html)`.canShowRendering(rendering: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [getRendering](get-rendering.md) | Returns the most recent rendering shown by this view, or null if [bindShowRendering](bind-show-rendering.md) has never been called.`fun <RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> `[`View`](https://developer.android.com/reference/android/view/View.html)`.getRendering(): RenderingT?` |
| [getShowRendering](get-show-rendering.md) | Returns the function set by the most recent call to [bindShowRendering](bind-show-rendering.md), or null if that method has never been called.`fun <RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> `[`View`](https://developer.android.com/reference/android/view/View.html)`.getShowRendering(): `[`ViewShowRendering`](../-view-show-rendering.md)`<RenderingT>?` |
| [hints](hints.md) | Returns the most recent [ContainerHints](../-container-hints/index.md) that apply to this view, or null if [bindShowRendering](bind-show-rendering.md) has never been called.`val `[`View`](https://developer.android.com/reference/android/view/View.html)`.hints: `[`ContainerHints`](../-container-hints/index.md)`?` |
| [showRendering](show-rendering.md) | It is usually more convenient to use [WorkflowViewStub](../-workflow-view-stub/index.md) than to call this method directly.`fun <RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> `[`View`](https://developer.android.com/reference/android/view/View.html)`.showRendering(rendering: RenderingT, containerHints: `[`ContainerHints`](../-container-hints/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
