[workflow-ui-android](../../index.md) / [com.squareup.workflow.ui](../index.md) / [androidx.fragment.app.FragmentActivity](index.md) / [setContentWorkflow](./set-content-workflow.md)

# setContentWorkflow

`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> FragmentActivity.setContentWorkflow(containerHints: `[`ContainerHints`](../-container-hints/index.md)`, configure: () -> Config<PropsT, OutputT>, onResult: (OutputT) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowRunner`](../-workflow-runner/index.md)`<OutputT>`

Call this method from [FragmentActivity.onCreate](#), instead of [FragmentActivity.setContentView](#).
It creates a [WorkflowRunner](../-workflow-runner/index.md) for this activity, if one doesn't already exist, and
sets a view driven by that model as the content view.

### Parameters

`containerHints` - provides the [ViewRegistry](../-view-registry/index.md) used to display workflow renderings.

`configure` - function defining the root workflow and its environment. Called only
once per [lifecycle](#), and always called from the UI thread.

`onResult` - function called with the first (and only) output emitted by the root workflow,
handy for passing to [FragmentActivity.setResult](#). The workflow is ended once it emits any
values, so this is also a good place from which to call [FragmentActivity.finish](#). Called
only while the activity is active, and always called from the UI thread.`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> FragmentActivity.setContentWorkflow(registry: `[`ViewRegistry`](../-view-registry/index.md)`, configure: () -> Config<PropsT, OutputT>, onResult: (OutputT) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowRunner`](../-workflow-runner/index.md)`<OutputT>`

Call this method from [FragmentActivity.onCreate](#), instead of [FragmentActivity.setContentView](#).
It creates a [WorkflowRunner](../-workflow-runner/index.md) for this activity, if one doesn't already exist, and
sets a view driven by that model as the content view.

### Parameters

`registry` - used to display workflow renderings.

`configure` - function defining the root workflow and its environment. Called only
once per [lifecycle](#), and always called from the UI thread.

`onResult` - function called with the first (and only) output emitted by the root workflow,
handy for passing to [FragmentActivity.setResult](#). The workflow is ended once it emits any
values, so this is also a good place from which to call [FragmentActivity.finish](#). Called
only while the activity is active, and always called from the UI thread.`fun <PropsT> FragmentActivity.setContentWorkflow(containerHints: `[`ContainerHints`](../-container-hints/index.md)`, configure: () -> Config<PropsT, `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>): `[`WorkflowRunner`](../-workflow-runner/index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>`

For workflows that produce no output, call this method from [FragmentActivity.onCreate](#)
instead of [FragmentActivity.setContentView](#).
It creates a [WorkflowRunner](../-workflow-runner/index.md) for this activity, if one doesn't already exist, and
sets a view driven by that model as the content view.

### Parameters

`containerHints` - provides the [ViewRegistry](../-view-registry/index.md) used to display workflow renderings.

`configure` - function defining the root workflow and its environment. Called only
once per [lifecycle](#), and always called from the UI thread.`fun <PropsT> FragmentActivity.setContentWorkflow(registry: `[`ViewRegistry`](../-view-registry/index.md)`, configure: () -> Config<PropsT, `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>): `[`WorkflowRunner`](../-workflow-runner/index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>`

For workflows that produce no output, call this method from [FragmentActivity.onCreate](#)
instead of [FragmentActivity.setContentView](#).
It creates a [WorkflowRunner](../-workflow-runner/index.md) for this activity, if one doesn't already exist, and
sets a view driven by that model as the content view.

### Parameters

`registry` - used to display workflow renderings.

`configure` - function defining the root workflow and its environment. Called only
once per [lifecycle](#), and always called from the UI thread.