[workflow-ui-android](../index.md) / [com.squareup.workflow.ui](./index.md)

## Package com.squareup.workflow.ui

### Types

| Name | Summary |
|---|---|
| [AlertContainer](-alert-container/index.md) | Renders the [AlertScreen](#)s of an [AlertContainerScreen](#) as [AlertDialog](#)s.`class AlertContainer : `[`ModalContainer`](-modal-container/index.md)`<AlertScreen>` |
| [BackPressHandler](-back-press-handler.md) | A function passed to [View.backPressedHandler](android.view.-view/back-pressed-handler.md), to be called if the back button is pressed while that view is attached to a window.`typealias BackPressHandler = () -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [BuilderBinding](-builder-binding/index.md) | A [ViewBinding](-view-binding/index.md) that allows a [ViewRegistry](-view-registry/index.md) to create [View](https://developer.android.com/reference/android/view/View.html)s that need to be generated from code. (Use [LayoutRunner](-layout-runner/index.md) to work with XML layout resources.)`class BuilderBinding<RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`ViewBinding`](-view-binding/index.md)`<RenderingT>` |
| [ContainerHintKey](-container-hint-key/index.md) | Defines a value that can be provided by a [ContainerHints](-container-hints/index.md) map, specifying its [type](#) and [default](-container-hint-key/default.md) value.`abstract class ContainerHintKey<T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
| [ContainerHints](-container-hints/index.md) | Immutable, append-only map of values that a parent view can pass down to its children via [View.showRendering](android.view.-view/show-rendering.md) et al. Allows container views to give descendants information about the context in which they're drawing.`class ContainerHints` |
| [LayoutRunner](-layout-runner/index.md) | A delegate that implements a [showRendering](-layout-runner/show-rendering.md) method to be called when a workflow rendering of type [RenderingT](-layout-runner/index.md#RenderingT) is ready to be displayed in a view inflated from a layout resource by a [ViewRegistry](-view-registry/index.md). (Use [BuilderBinding](-builder-binding/index.md) if you want to build views from code rather than layouts.)`interface LayoutRunner<RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
| [ModalContainer](-modal-container/index.md) | Base class for containers that show [HasModals.modals](#) in [Dialog](https://developer.android.com/reference/android/app/Dialog.html) windows.`abstract class ModalContainer<ModalRenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`FrameLayout`](https://developer.android.com/reference/android/widget/FrameLayout.html) |
| [ModalViewContainer](-modal-view-container/index.md) | Container that shows [HasModals.modals](#) as arbitrary views in a [Dialog](https://developer.android.com/reference/android/app/Dialog.html) window. Provides compatibility with [View.backPressedHandler](android.view.-view/back-pressed-handler.md).`open class ModalViewContainer : `[`ModalContainer`](-modal-container/index.md)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
| [ShowRenderingTag](-show-rendering-tag/index.md) | ` * View tag that holds the function to make the view show instances of [RenderingT](-show-rendering-tag/index.md#RenderingT), and the [current rendering](-show-rendering-tag/showing.md).`data class ShowRenderingTag<out RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
| [ViewBinding](-view-binding/index.md) | Factory for [View](https://developer.android.com/reference/android/view/View.html) instances that can show renderings of type[RenderingT](-view-binding/index.md#RenderingT). Use [LayoutRunner.bind](-layout-runner/bind.md) to work with XML layout resources, or [BuilderBinding](-builder-binding/index.md) to create views from code.`interface ViewBinding<RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
| [ViewRegistry](-view-registry/index.md) | A collection of [ViewBinding](-view-binding/index.md)s that can be used to display the stream of renderings from a workflow tree.`interface ViewRegistry` |
| [ViewShowRendering](-view-show-rendering.md) | Function attached to a view created by [ViewRegistry](-view-registry/index.md), to allow it to respond to [View.showRendering](android.view.-view/show-rendering.md).`typealias ViewShowRendering<RenderingT> = (RenderingT, `[`ContainerHints`](-container-hints/index.md)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [WorkflowFragment](-workflow-fragment/index.md) | A [Fragment](#) that can run a workflow. Subclasses implement [onCreateWorkflow](-workflow-fragment/on-create-workflow.md) to configure themselves with a [Workflow](#), [ViewRegistry](-view-registry/index.md) and [inputs](#).`abstract class WorkflowFragment<PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : Fragment` |
| [WorkflowLayout](-workflow-layout/index.md) | A view that can be driven by a [WorkflowRunner](-workflow-runner/index.md). In most cases you'll use [Activity.setContentWorkflow](androidx.fragment.app.-fragment-activity/set-content-workflow.md) or subclass [WorkflowFragment](-workflow-fragment/index.md) rather than manage this class directly.`class WorkflowLayout : `[`FrameLayout`](https://developer.android.com/reference/android/widget/FrameLayout.html) |
| [WorkflowRunner](-workflow-runner/index.md) | Uses a [Workflow](#) and a [ViewRegistry](-view-registry/index.md) to drive a [WorkflowLayout](-workflow-layout/index.md).`interface WorkflowRunner<out OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
| [WorkflowViewStub](-workflow-view-stub/index.md) | A placeholder [View](https://developer.android.com/reference/android/view/View.html) that can replace itself with ones driven by workflow renderings, similar to [android.view.ViewStub](https://developer.android.com/reference/android/view/ViewStub.html).`class WorkflowViewStub : `[`View`](https://developer.android.com/reference/android/view/View.html) |

### Extensions for External Classes

| Name | Summary |
|---|---|
| [android.content.Context](android.content.-context/index.md) |  |
| [android.view.View](android.view.-view/index.md) |  |
| [androidx.fragment.app.FragmentActivity](androidx.fragment.app.-fragment-activity/index.md) |  |

### Functions

| Name | Summary |
|---|---|
| [buildView](build-view.md) | It is usually more convenient to use [WorkflowViewStub](-workflow-view-stub/index.md) than to call this method directly.`fun <RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> `[`ViewRegistry`](-view-registry/index.md)`.buildView(initialRendering: RenderingT, initialContainerHints: `[`ContainerHints`](-container-hints/index.md)`, container: `[`ViewGroup`](https://developer.android.com/reference/android/view/ViewGroup.html)`): `[`View`](https://developer.android.com/reference/android/view/View.html) |
| [plus](plus.md) | `operator fun `[`ViewRegistry`](-view-registry/index.md)`.plus(binding: `[`ViewBinding`](-view-binding/index.md)`<*>): `[`ViewRegistry`](-view-registry/index.md)<br>`operator fun `[`ViewRegistry`](-view-registry/index.md)`.plus(other: `[`ViewRegistry`](-view-registry/index.md)`): `[`ViewRegistry`](-view-registry/index.md) |
| [ViewRegistry](-view-registry.md) | `fun ViewRegistry(vararg bindings: `[`ViewBinding`](-view-binding/index.md)`<*>): `[`ViewRegistry`](-view-registry/index.md)<br>Returns a [ViewRegistry](-view-registry/index.md) that merges all the given [registries](-view-registry.md#com.squareup.workflow.ui$ViewRegistry(kotlin.Array((com.squareup.workflow.ui.ViewRegistry)))/registries).`fun ViewRegistry(vararg registries: `[`ViewRegistry`](-view-registry/index.md)`): `[`ViewRegistry`](-view-registry/index.md)<br>Returns a [ViewRegistry](-view-registry/index.md) that contains no bindings.`fun ViewRegistry(): `[`ViewRegistry`](-view-registry/index.md) |
