[workflow-ui-compose](../index.md) / [com.squareup.workflow.compose](index.md) / [WorkflowContainer](./-workflow-container.md)

# WorkflowContainer

`@Composable fun <P, O : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, R : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> WorkflowContainer(workflow: Workflow<`[`P`](-workflow-container.md#P)`, `[`O`](-workflow-container.md#O)`, `[`R`](-workflow-container.md#R)`>, props: `[`P`](-workflow-container.md#P)`, onOutput: (`[`O`](-workflow-container.md#O)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, diagnosticListener: WorkflowDiagnosticListener? = null, immediateDispatcher: CoroutineDispatcher = Dispatchers.Main.immediate, children: (rendering: `[`R`](-workflow-container.md#R)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)

Render a [Workflow](#)'s renderings.

When this function is first composed it will start a new runtime. This runtime will be restarted
any time [workflow](-workflow-container.md#com.squareup.workflow.compose$WorkflowContainer(com.squareup.workflow.Workflow((com.squareup.workflow.compose.WorkflowContainer.P, com.squareup.workflow.compose.WorkflowContainer.O, com.squareup.workflow.compose.WorkflowContainer.R)), com.squareup.workflow.compose.WorkflowContainer.P, kotlin.Function1((com.squareup.workflow.compose.WorkflowContainer.O, kotlin.Unit)), com.squareup.workflow.diagnostic.WorkflowDiagnosticListener, kotlinx.coroutines.CoroutineDispatcher, kotlin.Function1((com.squareup.workflow.compose.WorkflowContainer.R, kotlin.Unit)))/workflow), [diagnosticListener](-workflow-container.md#com.squareup.workflow.compose$WorkflowContainer(com.squareup.workflow.Workflow((com.squareup.workflow.compose.WorkflowContainer.P, com.squareup.workflow.compose.WorkflowContainer.O, com.squareup.workflow.compose.WorkflowContainer.R)), com.squareup.workflow.compose.WorkflowContainer.P, kotlin.Function1((com.squareup.workflow.compose.WorkflowContainer.O, kotlin.Unit)), com.squareup.workflow.diagnostic.WorkflowDiagnosticListener, kotlinx.coroutines.CoroutineDispatcher, kotlin.Function1((com.squareup.workflow.compose.WorkflowContainer.R, kotlin.Unit)))/diagnosticListener), [immediateDispatcher](-workflow-container.md#com.squareup.workflow.compose$WorkflowContainer(com.squareup.workflow.Workflow((com.squareup.workflow.compose.WorkflowContainer.P, com.squareup.workflow.compose.WorkflowContainer.O, com.squareup.workflow.compose.WorkflowContainer.R)), com.squareup.workflow.compose.WorkflowContainer.P, kotlin.Function1((com.squareup.workflow.compose.WorkflowContainer.O, kotlin.Unit)), com.squareup.workflow.diagnostic.WorkflowDiagnosticListener, kotlinx.coroutines.CoroutineDispatcher, kotlin.Function1((com.squareup.workflow.compose.WorkflowContainer.R, kotlin.Unit)))/immediateDispatcher), or the `CoroutineContext`
changes. The runtime will be cancelled when this function stops composing.

### Parameters

`workflow` - The [Workflow](#) to render.

`props` - The props to render the root workflow with. If this value changes between calls,
the workflow runtime will re-render with the new props.

`onOutput` - A function that will be invoked any time the root workflow emits an output.

`diagnosticListener` - A [WorkflowDiagnosticListener](#) to configure on the runtime.

`immediateDispatcher` - The [CoroutineDispatcher](#) to use for the workflow runtime. This will
always override any dispatcher in the current coroutine context.

`children` - A [Composable](#) function that gets executed every time the root workflow spits
out a new rendering.