[workflow-ui-compose](../index.md) / [com.squareup.workflow.ui.compose](index.md) / [ChildWorkflowRendering](./-child-workflow-rendering.md)

# ChildWorkflowRendering

`@Composable fun <RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> ChildWorkflowRendering(rendering: `[`RenderingT`](-child-workflow-rendering.md#RenderingT)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)

Displays a rendering using the current [ViewRegistry](#) to
generate the view.

## Example

```
data class FramedRendering(
  val borderColor: Color,
  val child: Any
)

val FramedContainerBinding = bindCompose { rendering: FramedRendering ->
  Surface(border = Border(rendering.borderColor, 8.dp)) {
    ChildWorkflowRendering(rendering.child)
  }
}
```

### Exceptions

`IllegalStateException` - If not called from a [bindCompose](bind-compose.md) context.