[workflow-ui-compose](../index.md) / [com.squareup.workflow.ui.compose](index.md) / [bindCompose](./bind-compose.md)

# bindCompose

`inline fun <reified RenderingT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> bindCompose(noinline showRendering: (`[`RenderingT`](bind-compose.md#RenderingT)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): ViewBinding<`[`RenderingT`](bind-compose.md#RenderingT)`>`

Creates a [ViewBinding](#) that uses a [Composable](#) function to display the rendering.

Note that the function you pass in will not have any `MaterialTheme` applied, so views that rely
on Material theme attributes must be explicitly wrapped with `MaterialTheme`.

Simple usage:

```
// Function references to @Composable functions aren't supported yet.
val FooBinding = bindCompose { showFoo(it) }

@Composable
private fun showFoo(foo: FooRendering) {
  MaterialTheme {
    Text(foo.message)
  }
}

…

val viewRegistry = ViewRegistry(FooBinding, …)
```

If your view needs access to [ContainerHints](#), for example to display differently in
master/detail vs single pane mode, use [ambientContainerHint](ambient-container-hint.md).

## Implementing Containers

Views that act as containers (i.e. they delegate to the
[ViewRegistry](#) to render other rendering types) may use
[ChildWorkflowRendering](-child-workflow-rendering.md) to compose child renderings. See the kdoc on that function for more
information.

