[workflow-ui-core](../../index.md) / [com.squareup.workflow.ui](../index.md) / [BackStackScreen](./index.md)

# BackStackScreen

`class BackStackScreen<StackedT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`

Represents an active screen ([top](top.md)), and a set of previously visited
screens to which we may return ([backStack](back-stack.md)). By rendering the entire
history we allow the UI to do things like maintain cached view state,
implement drag-back gestures without waiting for the workflow, etc.

Effectively a list that can never be empty.

### Parameters

`bottom` - the bottom-most entry in the stack

`rest` - the rest of the stack, empty by default

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | Creates a screen with elements listed from the [bottom](-init-.md#com.squareup.workflow.ui.BackStackScreen$<init>(com.squareup.workflow.ui.BackStackScreen.StackedT, kotlin.Array((com.squareup.workflow.ui.BackStackScreen.StackedT)))/bottom) to the top.`BackStackScreen(bottom: StackedT, vararg rest: StackedT)`<br>Represents an active screen ([top](top.md)), and a set of previously visited screens to which we may return ([backStack](back-stack.md)). By rendering the entire history we allow the UI to do things like maintain cached view state, implement drag-back gestures without waiting for the workflow, etc.`BackStackScreen(bottom: StackedT, rest: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<StackedT>)` |

### Properties

| Name | Summary |
|---|---|
| [backStack](back-stack.md) | Screens to which we may return.`val backStack: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<StackedT>` |
| [frames](frames.md) | `val frames: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<StackedT>` |
| [top](top.md) | The active screen.`val top: StackedT` |

### Functions

| Name | Summary |
|---|---|
| [equals](equals.md) | `fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [get](get.md) | `operator fun get(index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): StackedT` |
| [hashCode](hash-code.md) | `fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [map](map.md) | `fun <R : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> map(transform: (StackedT) -> R): `[`BackStackScreen`](./index.md)`<R>` |
| [mapIndexed](map-indexed.md) | `fun <R : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> mapIndexed(transform: (index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, StackedT) -> R): `[`BackStackScreen`](./index.md)`<R>` |
| [plus](plus.md) | `operator fun plus(other: `[`BackStackScreen`](./index.md)`<StackedT>?): `[`BackStackScreen`](./index.md)`<StackedT>` |
| [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
