[workflow-ui-core](../../index.md) / [com.squareup.workflow.ui](../index.md) / [Compatible](./index.md)

# Compatible

`interface Compatible`

Implemented by objects whose [compatibility](../compatible.md) requires more nuance
than just being of the same type.

Renderings that don't implement this interface directly can be distinguished
by wrapping them with [Named](../-named/index.md).

### Properties

| Name | Summary |
|---|---|
| [compatibilityKey](compatibility-key.md) | Instances of the same type are [compatible](../compatible.md) iff they have the same [compatibilityKey](compatibility-key.md).`abstract val compatibilityKey: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Inheritors

| Name | Summary |
|---|---|
| [Named](../-named/index.md) | Allows renderings that do not implement [Compatible](./index.md) themselves to be distinguished by more than just their type. Instances are [compatible](../compatible.md) if they have the same name and have [compatible](../-named/wrapped.md) fields.`data class Named<W : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`Compatible`](./index.md) |
