[workflow-ui-core](../../index.md) / [com.squareup.workflow.ui](../index.md) / [Named](./index.md)

# Named

`data class Named<W : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`Compatible`](../-compatible/index.md)

Allows renderings that do not implement [Compatible](../-compatible/index.md) themselves to be distinguished
by more than just their type. Instances are [compatible](../compatible.md) if they have the same name
and have [compatible](wrapped.md) fields.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | Allows renderings that do not implement [Compatible](../-compatible/index.md) themselves to be distinguished by more than just their type. Instances are [compatible](../compatible.md) if they have the same name and have [compatible](wrapped.md) fields.`Named(wrapped: W, name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`)` |

### Properties

| Name | Summary |
|---|---|
| [compatibilityKey](compatibility-key.md) | Instances of the same type are [compatible](../compatible.md) iff they have the same [compatibilityKey](../-compatible/compatibility-key.md).`val compatibilityKey: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [name](name.md) | `val name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [wrapped](wrapped.md) | `val wrapped: W` |

### Functions

| Name | Summary |
|---|---|
| [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [keyFor](key-for.md) | Calculates the [Named.compatibilityKey](compatibility-key.md) for a given [value](key-for.md#com.squareup.workflow.ui.Named.Companion$keyFor(kotlin.Any, kotlin.String)/value) and [name](key-for.md#com.squareup.workflow.ui.Named.Companion$keyFor(kotlin.Any, kotlin.String)/name).`fun keyFor(value: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = ""): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
