[workflow-ui-core](../index.md) / [com.squareup.workflow.ui](./index.md)

## Package com.squareup.workflow.ui

### Types

| Name | Summary |
|---|---|
| [AlertContainerScreen](-alert-container-screen/index.md) | May show a stack of [AlertScreen](-alert-screen/index.md) over a [beneathModals](-alert-container-screen/beneath-modals.md).`data class AlertContainerScreen<B : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`HasModals`](-has-modals/index.md)`<B, `[`AlertScreen`](-alert-screen/index.md)`>` |
| [AlertScreen](-alert-screen/index.md) | Models a typical "You sure about that?" alert box.`data class AlertScreen` |
| [BackStackScreen](-back-stack-screen/index.md) | Represents an active screen ([top](-back-stack-screen/top.md)), and a set of previously visited screens to which we may return ([backStack](-back-stack-screen/back-stack.md)). By rendering the entire history we allow the UI to do things like maintain cached view state, implement drag-back gestures without waiting for the workflow, etc.`class BackStackScreen<StackedT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
| [Compatible](-compatible/index.md) | Implemented by objects whose [compatibility](compatible.md) requires more nuance than just being of the same type.`interface Compatible` |
| [HasModals](-has-modals/index.md) | Interface implemented by screen classes that represent a stack of zero or more [modal](-has-modals/index.md#M) screens above a [base screen](-has-modals/beneath-modals.md).`interface HasModals<out B : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, out M : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
| [Named](-named/index.md) | Allows renderings that do not implement [Compatible](-compatible/index.md) themselves to be distinguished by more than just their type. Instances are [compatible](compatible.md) if they have the same name and have [compatible](-named/wrapped.md) fields.`data class Named<W : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`Compatible`](-compatible/index.md) |

### Extensions for External Classes

| Name | Summary |
|---|---|
| [kotlin.collections.List](kotlin.collections.-list/index.md) |  |

### Functions

| Name | Summary |
|---|---|
| [compatible](compatible.md) | Normally returns true if [me](compatible.md#com.squareup.workflow.ui$compatible(kotlin.Any, kotlin.Any)/me) and [you](compatible.md#com.squareup.workflow.ui$compatible(kotlin.Any, kotlin.Any)/you) are instances of the same class. If that common class implements [Compatible](-compatible/index.md), both instances must also have the same [Compatible.compatibilityKey](-compatible/compatibility-key.md).`fun compatible(me: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, you: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
