//[trace-encoder](../../../index.md)/[com.squareup.tracing](../index.md)/[TraceEncoder](index.md)

# TraceEncoder

class [TraceEncoder](index.md)(scope: CoroutineScope, start: [TimeMark](../-time-mark/index.md) = TraceEncoderTimeMark, ioDispatcher: CoroutineDispatcher = IO, sinkProvider: () -&gt; BufferedSink) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)

Encodes and writes [trace events](../-trace-event/index.md) to an Okio BufferedSink.

#### Parameters

jvm

| | |
|---|---|
| scope | The CoroutineScope that defines the lifetime for the encoder. When the scope is cancelled or fails, the sink returned from sinkProvider will be closed. |
| start | The [TimeMark](../-time-mark/index.md) to consider the beginning timestamp of the trace. All trace events' timestamps are relative to this mark. [TimeSource.Monotonic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-time-source/-monotonic/index.html).[markNow](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-time-source/-monotonic/mark-now.html) by default. |
| ioDispatcher | The CoroutineDispatcher to use to execute all IO operations. IO by default. |
| sinkProvider | Returns the BufferedSink to use to write trace events to. Called on a background thread. |

## Constructors

| | |
|---|---|
| [TraceEncoder](-trace-encoder.md) | [jvm]<br>constructor(scope: CoroutineScope, start: [TimeMark](../-time-mark/index.md) = TraceEncoderTimeMark, ioDispatcher: CoroutineDispatcher = IO, sinkProvider: () -&gt; BufferedSink) |

## Functions

| Name | Summary |
|---|---|
| [close](close.md) | [jvm]<br>open override fun [close](close.md)() |
| [createLogger](create-logger.md) | [jvm]<br>fun [createLogger](create-logger.md)(processName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = &quot;&quot;, threadName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = &quot;&quot;): [TraceLogger](../-trace-logger/index.md)<br>Allocates a new thread ID named [threadName](create-logger.md) and returns a [TraceLogger](../-trace-logger/index.md) that will log all events under that thread ID. |
