//[trace-encoder](../../../index.md)/[com.squareup.tracing](../index.md)/[TraceEvent](index.md)

# TraceEvent

sealed class [TraceEvent](index.md)

Represents a single event in a trace.

#### Inheritors

| |
|---|
| [DurationBegin](-duration-begin/index.md) |
| [DurationEnd](-duration-end/index.md) |
| [Instant](-instant/index.md) |
| [AsyncDurationBegin](-async-duration-begin/index.md) |
| [AsyncDurationEnd](-async-duration-end/index.md) |
| [ObjectCreated](-object-created/index.md) |
| [ObjectDestroyed](-object-destroyed/index.md) |
| [ObjectSnapshot](-object-snapshot/index.md) |
| [Counter](-counter/index.md) |

## Types

| Name | Summary |
|---|---|
| [AsyncDurationBegin](-async-duration-begin/index.md) | [jvm]<br>data class [AsyncDurationBegin](-async-duration-begin/index.md)(val id: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val args: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt; = emptyMap(), val category: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null) : [TraceEvent](index.md) |
| [AsyncDurationEnd](-async-duration-end/index.md) | [jvm]<br>data class [AsyncDurationEnd](-async-duration-end/index.md)(val id: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val args: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt; = emptyMap(), val category: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null) : [TraceEvent](index.md) |
| [Counter](-counter/index.md) | [jvm]<br>data class [Counter](-counter/index.md)(val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val series: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)&gt;, val id: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)? = null) : [TraceEvent](index.md) |
| [DurationBegin](-duration-begin/index.md) | [jvm]<br>data class [DurationBegin](-duration-begin/index.md)(val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val args: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt; = emptyMap(), val category: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null) : [TraceEvent](index.md) |
| [DurationEnd](-duration-end/index.md) | [jvm]<br>data class [DurationEnd](-duration-end/index.md)(val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val args: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt; = emptyMap(), val category: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null) : [TraceEvent](index.md) |
| [Instant](-instant/index.md) | [jvm]<br>data class [Instant](-instant/index.md)(val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val args: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt; = emptyMap(), val scope: [TraceEvent.Instant.InstantScope](-instant/-instant-scope/index.md) = THREAD, val category: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null) : [TraceEvent](index.md) |
| [ObjectCreated](-object-created/index.md) | [jvm]<br>data class [ObjectCreated](-object-created/index.md)(val id: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), val objectType: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) : [TraceEvent](index.md) |
| [ObjectDestroyed](-object-destroyed/index.md) | [jvm]<br>data class [ObjectDestroyed](-object-destroyed/index.md)(val id: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), val objectType: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) : [TraceEvent](index.md) |
| [ObjectSnapshot](-object-snapshot/index.md) | [jvm]<br>data class [ObjectSnapshot](-object-snapshot/index.md)(val id: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), val objectType: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val snapshot: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)) : [TraceEvent](index.md) |

## Properties

| Name | Summary |
|---|---|
| [category](category.md) | [jvm]<br>open val [category](category.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
