//[trace-encoder](../../index.md)/[com.squareup.tracing](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [TimeMark](-time-mark/index.md) | [jvm]<br>interface [TimeMark](-time-mark/index.md)<br>Interface that represents a time point. Remains bound to the time source it was taken from and allows querying for the duration of time elapsed from that point (see the val [elapsedNow](-time-mark/elapsed-now.md)). |
| [TraceEncoder](-trace-encoder/index.md) | [jvm]<br>class [TraceEncoder](-trace-encoder/index.md)(scope: CoroutineScope, start: [TimeMark](-time-mark/index.md) = TraceEncoderTimeMark, ioDispatcher: CoroutineDispatcher = IO, sinkProvider: () -&gt; BufferedSink) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)<br>Encodes and writes [trace events](-trace-event/index.md) to an Okio BufferedSink. |
| [TraceEvent](-trace-event/index.md) | [jvm]<br>sealed class [TraceEvent](-trace-event/index.md)<br>Represents a single event in a trace. |
| [TraceLogger](-trace-logger/index.md) | [jvm]<br>interface [TraceLogger](-trace-logger/index.md)<br>[Logs](-trace-logger/log.md)[TraceEvent](-trace-event/index.md)s to a [TraceEncoder](-trace-encoder/index.md) under a given process and thread name. |
