/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.workflow1.internal.util;

import java.util.concurrent.atomic.AtomicReference;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u001f\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u0007*\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/squareup/workflow1/internal/util/UncaughtExceptionGuard;", "", "()V", "uncaughtException", "Ljava/util/concurrent/atomic/AtomicReference;", "", "reportUncaught", "", "e", "runRethrowingUncaught", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "addSuppressedSafely", "wf1-internal-testing-utils"})
public final class UncaughtExceptionGuard {
    @NotNull
    private final AtomicReference<Throwable> uncaughtException = new AtomicReference();

    public final void reportUncaught(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.uncaughtException.compareAndSet(null, e)) {
            Throwable throwable = this.uncaughtException.get();
            Intrinsics.checkNotNull((Object)throwable);
            this.addSuppressedSafely(throwable, e);
        }
    }

    public final <T> T runRethrowingUncaught(@NotNull Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            object = block.invoke();
        }
        catch (Throwable e) {
            this.addSuppressedSafely(e, this.uncaughtException.get());
            throw e;
        }
        Object result = object;
        object = this.uncaughtException.get();
        if (object != null) {
            Object it = object;
            boolean bl = false;
            throw it;
        }
        return (T)result;
    }

    private final void addSuppressedSafely(Throwable $this$addSuppressedSafely, Throwable e) {
        if (e != null && e != $this$addSuppressedSafely) {
            ExceptionsKt.addSuppressed((Throwable)$this$addSuppressedSafely, (Throwable)e);
        }
    }
}

